/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.SnakeDirection;
import znaishaded.net.sourceforge.plantuml.decoration.HtmlColorAndStyle;
import znaishaded.net.sourceforge.plantuml.decoration.LinkStyle;
import znaishaded.net.sourceforge.plantuml.klimt.Arrows;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.compress.CompressionMode;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.geom.MinMax;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XLine2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UPolygon;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.utils.Direction;

public class Worm
implements Iterable<XPoint2D> {
    private final List<XPoint2D> points = new ArrayList<XPoint2D>();
    private final Style style;
    private final Arrows arrows;
    private boolean ignoreForCompression;

    public Worm(Style style, Arrows arrows) {
        this.style = style;
        this.arrows = arrows;
    }

    public boolean isPureHorizontal() {
        return this.points.size() == 2 && this.points.get(0).getY() == this.points.get(1).getY();
    }

    public Worm cloneEmpty() {
        Worm result = new Worm(this.style, this.arrows);
        result.ignoreForCompression = this.ignoreForCompression;
        return result;
    }

    public final void setIgnoreForCompression() {
        if (this.points.size() > 0) {
            throw new IllegalStateException();
        }
        this.ignoreForCompression = true;
    }

    public void drawInternalOneColor(UPolygon startDecoration, UGraphic ug, HtmlColorAndStyle colorAndStyle, double strokeValue, Direction emphasizeDirection, UPolygon endDecoration) {
        HColor arrowColor = Objects.requireNonNull(colorAndStyle.getArrowColor());
        LinkStyle linkStyle = colorAndStyle.getStyle();
        if (linkStyle.isInvisible()) {
            return;
        }
        ug = ug.apply(arrowColor);
        ug = ug.apply(arrowColor.bg());
        ug = linkStyle.isNormal() ? ug.apply(this.style.getStroke()) : ug.apply(linkStyle.goThickness(strokeValue).getStroke3());
        boolean drawn = false;
        for (int i = 0; i < this.points.size() - 1; ++i) {
            XPoint2D p1 = this.points.get(i);
            XPoint2D p2 = this.points.get(i + 1);
            XLine2D line = XLine2D.line(p1, p2);
            if (!drawn && emphasizeDirection != null && Direction.fromVector(p1, p2) == emphasizeDirection) {
                this.drawLine(ug, line, emphasizeDirection);
                drawn = true;
                continue;
            }
            this.drawLine(ug, line, null);
        }
        HColor arrowHeadColor = colorAndStyle.getArrowHeadColor();
        if (arrowHeadColor == null) {
            throw new IllegalStateException();
        }
        ug = ug.apply(arrowHeadColor);
        ug = ug.apply(arrowHeadColor.bg());
        if (startDecoration != null) {
            ug = ug.apply(UStroke.withThickness(1.5));
            XPoint2D start = this.points.get(0);
            if (this.ignoreForCompression) {
                startDecoration.setCompressionMode(CompressionMode.ON_X);
            }
            ug.apply(UTranslate.point(start)).apply(UStroke.simple()).draw(startDecoration);
        }
        if (endDecoration != null) {
            ug = ug.apply(UStroke.withThickness(1.5));
            XPoint2D end = this.points.get(this.points.size() - 1);
            if (this.ignoreForCompression) {
                endDecoration.setCompressionMode(CompressionMode.ON_X);
            }
            ug.apply(UTranslate.point(end)).apply(UStroke.simple()).draw(endDecoration);
        }
    }

    private void drawLine(UGraphic ug, XLine2D line, Direction direction) {
        this.drawLine(ug, line.getX1(), line.getY1(), line.getX2(), line.getY2(), direction);
    }

    private void drawLine(UGraphic ug, double x1, double y1, double x2, double y2, Direction direction) {
        ug = ug.apply(new UTranslate(x1, y1));
        if (direction != null) {
            ug.apply(new UTranslate((x2 - x1) / 2.0, (y2 - y1) / 2.0)).draw(this.arrows.asTo(direction));
        }
        ug.draw(new ULine(x2 - x1, y2 - y1));
    }

    public Worm move(double dx, double dy) {
        Worm result = new Worm(this.style, this.arrows);
        for (XPoint2D pt : this.points) {
            result.addPoint(pt.getX() + dx, pt.getY() + dy);
        }
        return result;
    }

    public Worm moveFirstPoint(UTranslate move) {
        double dx = move.getDx();
        double dy = move.getDy();
        if (dx != 0.0 && dy != 0.0) {
            throw new IllegalArgumentException("move=" + move);
        }
        Worm result = new Worm(this.style, this.arrows);
        double x0 = this.points.get(0).getX();
        double y0 = this.points.get(0).getY();
        double x1 = this.points.get(1).getX();
        double y1 = this.points.get(1).getY();
        if (dx != 0.0 && x0 == x1) {
            x1 += dx;
        }
        if (dy != 0.0 && y0 == y1) {
            y1 += dy;
        }
        result.addPoint(x0 += dx, y0 += dy);
        result.addPoint(x1, y1);
        for (int i = 2; i < this.points.size(); ++i) {
            result.addPoint(this.points.get(i));
        }
        return result;
    }

    public Worm moveLastPoint(UTranslate move) {
        double dx = move.getDx();
        double dy = move.getDy();
        if (dx != 0.0 && dy != 0.0) {
            throw new IllegalArgumentException("move=" + move);
        }
        Worm result = new Worm(this.style, this.arrows);
        double x8 = this.points.get(this.points.size() - 2).getX();
        double y8 = this.points.get(this.points.size() - 2).getY();
        double x9 = this.points.get(this.points.size() - 1).getX();
        double y9 = this.points.get(this.points.size() - 1).getY();
        if (dx != 0.0 && x8 == x9) {
            x8 += dx;
        }
        if (dy != 0.0 && y8 == y9) {
            y8 += dy;
        }
        x9 += dx;
        y9 += dy;
        for (int i = 0; i < this.points.size() - 2; ++i) {
            result.addPoint(this.points.get(i));
        }
        result.addPoint(x8, y8);
        result.addPoint(x9, y9);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            result.append((Object)this.getDirectionAtPoint(i)).append(" ");
        }
        return result + this.points.toString();
    }

    public void addPoint(double x, double y) {
        XPoint2D last;
        if (Double.isNaN(x)) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(y)) {
            throw new IllegalArgumentException();
        }
        if (this.points.size() > 0 && (last = this.getLast()).getX() == x && last.getY() == y) {
            return;
        }
        this.points.add(new XPoint2D(x, y));
    }

    public void addPoint(XPoint2D pt) {
        this.addPoint(pt.getX(), pt.getY());
    }

    public Worm translate(UTranslate translate) {
        return this.move(translate.getDx(), translate.getDy());
    }

    SnakeDirection getDirection() {
        if (this.points.size() < 2) {
            throw new IllegalStateException();
        }
        return SnakeDirection.getDirection(this.points.get(0), this.points.get(1));
    }

    String getDirectionsCode() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Direction direction = Direction.fromVector(this.points.get(i), this.points.get(i + 1));
            result.append(direction.getShortCode());
        }
        return result.toString();
    }

    private List<Direction> getPatternAt(int i) {
        return Arrays.asList(this.getDirectionAtPoint(i), this.getDirectionAtPoint(i + 1), this.getDirectionAtPoint(i + 2), this.getDirectionAtPoint(i + 3));
    }

    private boolean isForwardAndBackwardAt(int i) {
        return this.getDirectionAtPoint(i) == this.getDirectionAtPoint(i + 1).getInv();
    }

    private Direction getDirectionAtPoint(int i) {
        return Direction.fromVector(this.points.get(i), this.points.get(i + 1));
    }

    @Override
    public Iterator<XPoint2D> iterator() {
        return Collections.unmodifiableCollection(this.points).iterator();
    }

    public boolean doesHorizontalCross(MinMax area) {
        for (int i = 0; i < this.points.size() - 1; ++i) {
            XPoint2D pt1 = this.get(i);
            XPoint2D pt2 = this.get(i + 1);
            if (pt1.getY() != pt2.getY() || !area.doesHorizontalCross(pt1, pt2)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.points.size();
    }

    public XPoint2D get(int i) {
        return this.points.get(i);
    }

    public void addAll(Worm other) {
        this.points.addAll(other.points);
    }

    public void remove(int i) {
        this.points.remove(i);
    }

    public void add(int i, XPoint2D pt) {
        this.points.add(i, pt);
    }

    public XPoint2D getFirst() {
        return this.points.get(0);
    }

    public XPoint2D getLast() {
        return this.points.get(this.points.size() - 1);
    }

    public double getMinX() {
        double result = this.points.get(0).getX();
        for (XPoint2D pt : this.points) {
            result = Math.min(result, pt.getX());
        }
        return result;
    }

    public double getMaxY() {
        double result = this.points.get(0).getY();
        for (XPoint2D pt : this.points) {
            result = Math.max(result, pt.getY());
        }
        return result;
    }

    public Worm merge(Worm other, MergeStrategy merge) {
        if (!Snake.same(this.getLast(), other.getFirst())) {
            throw new IllegalArgumentException();
        }
        Worm result = new Worm(this.style, this.arrows);
        result.points.addAll(this.points);
        result.points.addAll(other.points);
        result.mergeMe(merge);
        return result;
    }

    private void mergeMe(MergeStrategy merge) {
        boolean change = false;
        do {
            change = (change = false) || this.removeNullVector();
            change = change || this.removeRedondantDirection();
            change = change || this.removePattern1();
            change = change || this.removePattern2();
            change = change || this.removePattern3();
            change = change || this.removePattern4();
            change = change || this.removePattern5();
            change = change || this.removePattern6();
            boolean bl = change = change || this.removePattern7();
            if (merge != MergeStrategy.FULL) continue;
            boolean bl2 = change = change || this.removePattern8();
        } while (change);
    }

    private boolean removeNullVector() {
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Direction dir = this.getDirectionAtPoint(i);
            if (dir != null) continue;
            this.points.remove(i);
            return true;
        }
        return false;
    }

    private boolean removeRedondantDirection() {
        for (int i = 0; i < this.points.size() - 2; ++i) {
            Direction dir2;
            Direction dir1 = this.getDirectionAtPoint(i);
            if (dir1 != (dir2 = this.getDirectionAtPoint(i + 1))) continue;
            this.points.remove(i + 1);
            return true;
        }
        return false;
    }

    private boolean removePattern1() {
        for (int i = 0; i < this.points.size() - 5; ++i) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (!Arrays.asList(Direction.DOWN, Direction.LEFT, Direction.DOWN, Direction.RIGHT).equals(patternAt) && !Arrays.asList(Direction.DOWN, Direction.RIGHT, Direction.DOWN, Direction.LEFT).equals(patternAt)) continue;
            XPoint2D newPoint = new XPoint2D(this.points.get((int)(i + 1)).x, this.points.get((int)(i + 3)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, newPoint);
            return true;
        }
        return false;
    }

    private boolean removePattern7() {
        if (this.points.size() > 4) {
            boolean i = false;
            List<Direction> patternAt = this.getPatternAt(0);
            if (Arrays.asList(Direction.RIGHT, Direction.DOWN, Direction.LEFT, Direction.DOWN).equals(patternAt) && this.points.get((int)3).x > this.points.get((int)0).x) {
                XPoint2D newPoint = new XPoint2D(this.points.get((int)3).x, this.points.get((int)0).y);
                this.points.remove(2);
                this.points.remove(1);
                this.points.add(1, newPoint);
                return true;
            }
        }
        return false;
    }

    private boolean removePattern2() {
        for (int i = 0; i < this.points.size() - 5; ++i) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (!Arrays.asList(Direction.RIGHT, Direction.DOWN, Direction.RIGHT, Direction.UP).equals(patternAt) && !Arrays.asList(Direction.LEFT, Direction.DOWN, Direction.LEFT, Direction.UP).equals(patternAt)) continue;
            XPoint2D newPoint = new XPoint2D(this.points.get((int)(i + 3)).x, this.points.get((int)(i + 1)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, newPoint);
            return true;
        }
        return false;
    }

    private boolean removePattern3() {
        for (int i = 0; i < this.points.size() - 4; ++i) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (!Arrays.asList(Direction.DOWN, Direction.RIGHT, Direction.DOWN, Direction.RIGHT).equals(patternAt) && !Arrays.asList(Direction.DOWN, Direction.LEFT, Direction.DOWN, Direction.LEFT).equals(patternAt)) continue;
            XPoint2D newPoint = new XPoint2D(this.points.get((int)(i + 1)).x, this.points.get((int)(i + 3)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, newPoint);
            return true;
        }
        return false;
    }

    private boolean removePattern4() {
        int i = this.points.size() - 5;
        if (i >= 0) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (Arrays.asList(Direction.DOWN, Direction.LEFT, Direction.DOWN, Direction.RIGHT).equals(patternAt)) {
                XPoint2D p1 = this.points.get(i + 1);
                XPoint2D p4 = this.points.get(i + 4);
                if (p4.x > p1.x) {
                    XPoint2D newPoint = new XPoint2D(this.points.get((int)(i + 1)).x, this.points.get((int)(i + 3)).y);
                    this.points.remove(i + 3);
                    this.points.remove(i + 2);
                    this.points.remove(i + 1);
                    this.points.add(i + 1, newPoint);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean removePattern5() {
        int i = this.points.size() - 5;
        if (i >= 0) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (Arrays.asList(Direction.DOWN, Direction.RIGHT, Direction.DOWN, Direction.LEFT).equals(patternAt)) {
                XPoint2D p1 = this.points.get(i + 1);
                XPoint2D p4 = this.points.get(i + 4);
                if (p4.x + 4.0 < p1.x) {
                    XPoint2D newPoint = new XPoint2D(this.points.get((int)(i + 1)).x, this.points.get((int)(i + 3)).y);
                    this.points.remove(i + 3);
                    this.points.remove(i + 2);
                    this.points.remove(i + 1);
                    this.points.add(i + 1, newPoint);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean removePattern6() {
        for (int i = 0; i < this.points.size() - 2; ++i) {
            if (!this.isForwardAndBackwardAt(i)) continue;
            this.points.remove(i + 1);
            return true;
        }
        return false;
    }

    private boolean removePattern8() {
        for (int i = 0; i < this.points.size() - 4; ++i) {
            List<Direction> patternAt = this.getPatternAt(i);
            if (!Arrays.asList(Direction.LEFT, Direction.DOWN, Direction.LEFT, Direction.DOWN).equals(patternAt) && !Arrays.asList(Direction.RIGHT, Direction.DOWN, Direction.RIGHT, Direction.DOWN).equals(patternAt)) continue;
            XPoint2D newPoint = new XPoint2D(this.points.get((int)(i + 3)).x, this.points.get((int)(i + 1)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, newPoint);
            return true;
        }
        return false;
    }

    public Style getStyle() {
        return this.style;
    }
}

