/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.descdiagram;

import java.util.Map;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.LeafType;
import znaishaded.net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbol;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbols;
import znaishaded.net.sourceforge.plantuml.skin.UmlDiagramType;

public class DescriptionDiagram
extends AbstractEntityDiagram {
    public DescriptionDiagram(UmlSource source, Map<String, String> skinParam) {
        super(source, UmlDiagramType.DESCRIPTION, skinParam);
    }

    @Override
    public String cleanId(String id) {
        if (id == null) {
            return null;
        }
        if (id.startsWith("()")) {
            id = StringUtils.trin(id.substring(2));
        }
        if (id.startsWith(":") && id.endsWith(":/")) {
            return id.substring(1, id.length() - 2);
        }
        if (id.startsWith("(") && id.endsWith(")/")) {
            return id.substring(1, id.length() - 2);
        }
        return super.cleanId(id);
    }

    private boolean isUsecase() {
        for (Entity leaf : this.getEntityFactory().leafs()) {
            LeafType type = leaf.getLeafType();
            USymbol usymbol = leaf.getUSymbol();
            if (type != LeafType.USECASE && usymbol != this.getSkinParam().actorStyle().toUSymbol()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void makeDiagramReady() {
        super.makeDiagramReady();
        LeafType defaultType = LeafType.DESCRIPTION;
        USymbol defaultSymbol = this.isUsecase() ? this.getSkinParam().actorStyle().toUSymbol() : USymbols.INTERFACE;
        for (Entity leaf : this.getEntityFactory().leafs()) {
            if (leaf.getLeafType() != LeafType.STILL_UNKNOWN) continue;
            leaf.muteToType(defaultType, defaultSymbol);
        }
    }

    @Override
    public String checkFinalError() {
        this.applySingleStrategy();
        return super.checkFinalError();
    }
}

