/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.dot;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.dot.AbstractGraphviz;
import znaishaded.net.sourceforge.plantuml.dot.GraphvizUtils;
import znaishaded.net.sourceforge.plantuml.log.Logme;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.windowsdot.WindowsDotArchive;

class GraphvizWindowsOld
extends AbstractGraphviz {
    private static File specificDotExe;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected File specificDotExe() {
        Class<GraphvizWindowsOld> clazz = GraphvizWindowsOld.class;
        synchronized (GraphvizWindowsOld.class) {
            if (specificDotExe == null) {
                specificDotExe = this.specificDotExeSlow();
            }
            if (specificDotExe == null) {
                specificDotExe = WindowsDotArchive.getInstance().getWindowsExeLite();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return specificDotExe;
        }
    }

    @Override
    public boolean graphviz244onWindows() {
        try {
            return GraphvizUtils.getDotVersion() == 244;
        }
        catch (Exception e) {
            Logme.error(e);
            return false;
        }
    }

    private File specificDotExeSlow() {
        for (File tmp : new File("c:/").listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.canRead();
            }
        })) {
            File result = GraphvizWindowsOld.searchInDir(tmp);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static File searchInDir(File dir) {
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        ArrayList<File> dots = new ArrayList<File>();
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && StringUtils.goLowerCase(pathname.getName()).startsWith("graphviz");
            }
        });
        if (files == null) {
            return null;
        }
        for (File f : files) {
            File result2;
            File result = new File(new File(f, "bin"), "dot.exe");
            if (result.exists() && result.canRead()) {
                dots.add(result.getAbsoluteFile());
            }
            if (!(result2 = new File(new File(f, "release/bin"), "dot.exe")).exists() || !result2.canRead()) continue;
            dots.add(result2.getAbsoluteFile());
        }
        return GraphvizWindowsOld.higherVersion(dots);
    }

    static File higherVersion(List<File> dots) {
        if (dots.size() == 0) {
            return null;
        }
        Collections.sort(dots, Collections.reverseOrder());
        return dots.get(0);
    }

    GraphvizWindowsOld(ISkinParam skinParam, String dotString, String ... type) {
        super(skinParam, dotString, type);
    }

    @Override
    protected String getExeName() {
        return "dot.exe";
    }
}

