/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.plasma;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.plasma.Plasma;

public class Quark<DATA> {
    private final Plasma<DATA> plasma;
    private final Quark<DATA> parent;
    private final String name;
    private DATA data;
    private final Map<String, Quark<DATA>> children = new LinkedHashMap<String, Quark<DATA>>();
    private final String qualifiedName;

    Quark(Plasma<DATA> plasma, Quark<DATA> parent, String name) {
        this.name = name;
        this.plasma = plasma;
        this.parent = parent;
        this.qualifiedName = parent == null || parent.parent == null ? name : parent.qualifiedName + plasma.getSeparator() + name;
        this.plasma.register(this);
    }

    public Quark<DATA> getParent() {
        return this.parent;
    }

    public String toString() {
        return this.qualifiedName;
    }

    public String toStringPoint() {
        if (this.parent == null || this.parent.parent == null) {
            return this.name;
        }
        return this.parent.toStringPoint() + "." + this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public final Plasma<DATA> getPlasma() {
        return this.plasma;
    }

    public final DATA getData() {
        return this.data;
    }

    public final void setData(DATA data) {
        if (this.data != null) {
            throw new IllegalStateException();
        }
        this.data = data;
    }

    public Quark<DATA> childIfExists(String name) {
        if (this.plasma.hasSeparator() && name.contains(this.plasma.getSeparator())) {
            throw new IllegalArgumentException();
        }
        return this.children.get(name);
    }

    public Quark<DATA> child(String full) {
        if (!this.plasma.hasSeparator()) {
            return this.getDirectChild(full);
        }
        full = this.clean(full);
        String separator = this.plasma.getSeparator();
        Quark<DATA> current = this;
        int idx;
        while ((idx = full.indexOf(separator)) != -1) {
            String first = full.substring(0, idx);
            current = current.getDirectChild(first);
            full = super.clean(full.substring(idx + separator.length()));
        }
        return current.getDirectChild(full);
    }

    private Quark<DATA> getDirectChild(String name) {
        Quark<DATA> result = this.children.get(name);
        if (result == null) {
            result = new Quark<DATA>(this.plasma, this, name);
            this.children.put(name, result);
        }
        return result;
    }

    private String clean(String full) {
        String separator = this.plasma.getSeparator();
        while (full.startsWith(separator)) {
            full = full.substring(separator.length());
        }
        while (full.endsWith(separator)) {
            full = full.substring(0, full.length() - separator.length());
        }
        return full;
    }

    public Collection<Quark<DATA>> getChildren() {
        return Collections.unmodifiableCollection(this.children.values());
    }

    public int countChildren() {
        return this.children.size();
    }
}

