/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.project.DaysAsDates;
import znaishaded.net.sourceforge.plantuml.project.Failable;
import znaishaded.net.sourceforge.plantuml.project.GanttDiagram;
import znaishaded.net.sourceforge.plantuml.project.core.Resource;
import znaishaded.net.sourceforge.plantuml.project.lang.ComplementDate;
import znaishaded.net.sourceforge.plantuml.project.lang.ComplementDates;
import znaishaded.net.sourceforge.plantuml.project.lang.ComplementDayOfWeek;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceSimple;
import znaishaded.net.sourceforge.plantuml.project.lang.Subject;
import znaishaded.net.sourceforge.plantuml.project.lang.Verbs;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.time.DayOfWeek;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;

public class SubjectResource
implements Subject {
    public static final Subject ME = new SubjectResource();

    private SubjectResource() {
    }

    public Failable<Resource> getMe(GanttDiagram project, RegexResult arg) {
        String s2 = arg.get("RESOURCE", 0);
        return Failable.ok(project.getResource(s2));
    }

    @Override
    public Collection<? extends SentenceSimple> getSentences() {
        return Arrays.asList(new IsOffDate(), new IsOffDates(), new IsOffDayOfWeek(), new IsOnDate(), new IsOnDates());
    }

    @Override
    public IRegex toRegex() {
        return new RegexConcat(new RegexLeaf("RESOURCE", "\\{([^{}]+)\\}"));
    }

    public class IsOffDate
    extends SentenceSimple {
        public IsOffDate() {
            super(SubjectResource.this, Verbs.isOff, new ComplementDate());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            Resource resource = (Resource)subject;
            Day when = (Day)complement;
            resource.addCloseDay(when);
            return CommandExecutionResult.ok();
        }
    }

    public class IsOffDates
    extends SentenceSimple {
        public IsOffDates() {
            super(SubjectResource.this, Verbs.isOff, new ComplementDates());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            Resource resource = (Resource)subject;
            for (Day when : (DaysAsDates)complement) {
                resource.addCloseDay(when);
            }
            return CommandExecutionResult.ok();
        }
    }

    public class IsOffDayOfWeek
    extends SentenceSimple {
        public IsOffDayOfWeek() {
            super(SubjectResource.this, Verbs.isOff, new ComplementDayOfWeek());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            Resource resource = (Resource)subject;
            resource.addCloseDay((DayOfWeek)((Object)complement));
            return CommandExecutionResult.ok();
        }
    }

    public class IsOnDate
    extends SentenceSimple {
        public IsOnDate() {
            super(SubjectResource.this, Verbs.isOn, new ComplementDate());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            Resource resource = (Resource)subject;
            Day when = (Day)complement;
            resource.addForceOnDay(when);
            return CommandExecutionResult.ok();
        }
    }

    public class IsOnDates
    extends SentenceSimple {
        public IsOnDates() {
            super(SubjectResource.this, Verbs.isOn, new ComplementDates());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            Resource resource = (Resource)subject;
            for (Day when : (DaysAsDates)complement) {
                resource.addForceOnDay(when);
            }
            return CommandExecutionResult.ok();
        }
    }
}

