/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.project.Failable;
import znaishaded.net.sourceforge.plantuml.project.GanttDiagram;
import znaishaded.net.sourceforge.plantuml.project.Today;
import znaishaded.net.sourceforge.plantuml.project.lang.CenterBorderColor;
import znaishaded.net.sourceforge.plantuml.project.lang.ComplementDate;
import znaishaded.net.sourceforge.plantuml.project.lang.ComplementInColors;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceSimple;
import znaishaded.net.sourceforge.plantuml.project.lang.Subject;
import znaishaded.net.sourceforge.plantuml.project.lang.Verbs;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;

public class SubjectToday
implements Subject {
    public static final Subject ME = new SubjectToday();

    private SubjectToday() {
    }

    @Override
    public IRegex toRegex() {
        return new RegexConcat(new RegexLeaf("today"));
    }

    public Failable<Today> getMe(GanttDiagram project, RegexResult arg) {
        return Failable.ok(new Today());
    }

    @Override
    public Collection<? extends SentenceSimple> getSentences() {
        return Arrays.asList(new InColor(), new IsDate());
    }

    class InColor
    extends SentenceSimple {
        public InColor() {
            super(SubjectToday.this, Verbs.isColored, new ComplementInColors());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            Today task = (Today)subject;
            CenterBorderColor colors = (CenterBorderColor)complement;
            project.setTodayColors(colors);
            return CommandExecutionResult.ok();
        }
    }

    class IsDate
    extends SentenceSimple {
        public IsDate() {
            super(SubjectToday.this, Verbs.is, new ComplementDate());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            Day date = (Day)complement;
            return project.setToday(date);
        }
    }
}

