/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.real;

import znaishaded.net.sourceforge.plantuml.log.Logme;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.real.RealMoveable;

class PositiveForce {
    private final Real fixedPoint;
    private final RealMoveable movingPoint;
    private final double minimunDistance;
    private final boolean trace = false;
    private final Throwable creationPoint;

    public PositiveForce(Real fixedPoint, RealMoveable movingPoint, double minimunDistance) {
        if (fixedPoint == movingPoint) {
            throw new IllegalArgumentException();
        }
        this.fixedPoint = fixedPoint;
        this.movingPoint = movingPoint;
        this.minimunDistance = minimunDistance;
        this.creationPoint = new Throwable();
        this.creationPoint.fillInStackTrace();
    }

    public String toString() {
        return "PositiveForce fixed=" + this.fixedPoint + " moving=" + this.movingPoint + " min=" + this.minimunDistance;
    }

    public boolean apply() {
        double fixedPointValue;
        double movingPointValue = this.movingPoint.getCurrentValue();
        try {
            fixedPointValue = this.fixedPoint.getCurrentValue();
        }
        catch (IllegalStateException e) {
            System.err.println("Pb with force " + this);
            System.err.println("This force has been created here:");
            Logme.error(this.creationPoint);
            System.err.println("The fixed point has been created here: " + this.fixedPoint);
            this.fixedPoint.printCreationStackTrace();
            throw e;
        }
        double distance = movingPointValue - fixedPointValue;
        double diff = distance - this.minimunDistance;
        if (diff >= 0.0) {
            return false;
        }
        this.movingPoint.move(-diff);
        return true;
    }
}

