/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import java.util.List;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;
import znaishaded.net.sourceforge.plantuml.salt.element.TableStrategy;

public class Grid2 {
    private final List<Double> rowsStart;
    private final List<Double> colsStart;
    private final TableStrategy strategy;

    public Grid2(List<Double> rowsStart, List<Double> colsStart, TableStrategy strategy) {
        this.rowsStart = rowsStart;
        this.colsStart = colsStart;
        this.strategy = strategy;
    }

    public void drawU(UGraphic ug) {
        double xmin = this.colsStart.get(0);
        double xmax = this.colsStart.get(this.colsStart.size() - 1);
        double ymin = this.rowsStart.get(0);
        double ymax = this.rowsStart.get(this.rowsStart.size() - 1);
        if (this.strategy == TableStrategy.DRAW_OUTSIDE || this.strategy == TableStrategy.DRAW_OUTSIDE_WITH_TITLE) {
            ug.apply(new UTranslate(xmin, ymin)).draw(ULine.hline(xmax - xmin));
            ug.apply(new UTranslate(xmin, ymax)).draw(ULine.hline(xmax - xmin));
            ug.apply(new UTranslate(xmin, ymin)).draw(ULine.vline(ymax - ymin));
            ug.apply(new UTranslate(xmax, ymin)).draw(ULine.vline(ymax - ymin));
        }
        if (this.drawHorizontal()) {
            for (Double y : this.rowsStart) {
                ug.apply(new UTranslate(xmin, y)).draw(ULine.hline(xmax - xmin));
            }
        }
        if (this.drawVertical()) {
            for (Double x : this.colsStart) {
                ug.apply(new UTranslate(x, ymin)).draw(ULine.vline(ymax - ymin));
            }
        }
    }

    private boolean drawHorizontal() {
        return this.strategy == TableStrategy.DRAW_HORIZONTAL || this.strategy == TableStrategy.DRAW_ALL;
    }

    private boolean drawVertical() {
        return this.strategy == TableStrategy.DRAW_VERTICAL || this.strategy == TableStrategy.DRAW_ALL;
    }
}

