/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.util.EnumMap;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.klimt.UGroupType;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UPolygon;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;

public class EntityImageBranch
extends AbstractEntityImage {
    private static final int SIZE = 12;

    public EntityImageBranch(Entity entity, ISkinParam skinParam) {
        super(entity, skinParam);
    }

    public StyleSignatureBasic getDefaultStyleDefinition() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(24.0, 24.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UPolygon diams = new UPolygon();
        diams.addPoint(12.0, 0.0);
        diams.addPoint(24.0, 12.0);
        diams.addPoint(12.0, 24.0);
        diams.addPoint(0.0, 12.0);
        diams.addPoint(12.0, 0.0);
        Style style = this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
        HColor border = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        HColor back = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        UStroke stroke = style.getStroke();
        double shadowing = style.value(PName.Shadowing).asDouble();
        diams.setDeltaShadow(shadowing);
        EnumMap<UGroupType, String> typeIDent = new EnumMap<UGroupType, String>(UGroupType.class);
        typeIDent.put(UGroupType.CLASS, "elem " + this.getEntity().getName() + " selected");
        typeIDent.put(UGroupType.ID, "elem_" + this.getEntity().getName());
        ug.startGroup(typeIDent);
        ug.apply(border).apply(back.bg()).apply(stroke).draw(diams);
        ug.closeGroup();
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.DIAMOND;
    }
}

