/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import znaishaded.net.sourceforge.plantuml.abel.DisplayPositioned;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.EntityPortion;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import znaishaded.net.sourceforge.plantuml.cucadiagram.PortionShower;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.Colors;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontParam;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.RectangleArea;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.skin.AlignmentParam;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ClusterDecoration;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.text.Guillemet;
import znaishaded.net.sourceforge.plantuml.url.Url;

public class EntityImageEmptyPackage
extends AbstractEntityImage {
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final Stereotype stereotype;
    private final TextBlock stereoBlock;
    private final Url url;
    private final SName sname;
    private final double shadowing;
    private final HColor borderColor;
    private final UStroke stroke;
    private final double roundCorner;
    private final double diagonalCorner;
    private final HColor back;

    private Style getStyle() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.sname, SName.package_, SName.title).withTOBECHANGED(this.stereotype).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    public EntityImageEmptyPackage(Entity entity, ISkinParam skinParam, PortionShower portionShower, SName sname) {
        super(entity, skinParam);
        TextBlock legendBlock;
        this.sname = sname;
        Colors colors = entity.getColors();
        HColor specificBackColor = colors.getColor(ColorType.BACK);
        this.stereotype = entity.getStereotype();
        this.url = entity.getUrl99();
        Style style = this.getStyle();
        style = style.eventuallyOverride(colors);
        this.borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        this.shadowing = style.value(PName.Shadowing).asDouble();
        this.stroke = style.getStroke(colors);
        this.roundCorner = style.value(PName.RoundCorner).asDouble();
        this.diagonalCorner = style.value(PName.DiagonalCorner).asDouble();
        this.back = specificBackColor == null ? style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet()) : specificBackColor;
        FontConfiguration titleFontConfiguration = style.getFontConfiguration(this.getSkinParam().getIHtmlColorSet());
        HorizontalAlignment titleHorizontalAlignment = style.getHorizontalAlignment();
        this.desc = entity.getDisplay().create(titleFontConfiguration, titleHorizontalAlignment, skinParam);
        DisplayPositioned legend = entity.getLegend();
        this.stereoBlock = legend != null ? (legendBlock = EntityImageLegend.create(legend.getDisplay(), skinParam)) : (this.stereotype == null || this.stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? TextBlockUtils.empty(0.0, 0.0) : TextBlockUtils.withMargin(Display.create(this.stereotype.getLabels(skinParam.guillemet())).create(FontConfiguration.create(this.getSkinParam(), FontParam.PACKAGE_STEREOTYPE, this.stereotype), titleHorizontalAlignment, skinParam), 1.0, 0.0));
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        XDimension2D dim = TextBlockUtils.mergeTB(this.desc, this.stereoBlock, HorizontalAlignment.LEFT).calculateDimension(stringBounder);
        dim = dim.atLeast(0.0, 2.0 * dimDesc.getHeight());
        return dim.delta(20.0, 20.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        RectangleArea rectangleArea = new RectangleArea(0.0, 0.0, widthTotal, heightTotal);
        ClusterDecoration decoration = new ClusterDecoration(this.getSkinParam().packageStyle(), null, this.desc, this.stereoBlock, rectangleArea, this.stroke);
        HorizontalAlignment horizontalAlignment = this.getSkinParam().getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null);
        HorizontalAlignment stereotypeAlignment = this.getSkinParam().getStereotypeAlignment();
        decoration.drawU(ug, this.back, this.borderColor, this.shadowing, this.roundCorner, horizontalAlignment, stereotypeAlignment, this.diagonalCorner);
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

