/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.text;

import java.util.StringTokenizer;
import java.util.regex.Matcher;

public class Guillemet {
    public static final Guillemet NONE = new Guillemet("", "");
    public static final Guillemet DOUBLE_COMPARATOR = new Guillemet("<<", ">>");
    public static final Guillemet GUILLEMET = new Guillemet("\u00ab", "\u00bb");
    private final String start;
    private final String end;

    public Guillemet fromDescription(String value) {
        if (value != null) {
            if ("false".equalsIgnoreCase(value)) {
                return DOUBLE_COMPARATOR;
            }
            if ("<< >>".equalsIgnoreCase(value)) {
                return DOUBLE_COMPARATOR;
            }
            if ("none".equalsIgnoreCase(value)) {
                return NONE;
            }
            if (value.contains(" ")) {
                StringTokenizer st = new StringTokenizer(value, " ");
                return new Guillemet(st.nextToken(), st.nextToken());
            }
        }
        return GUILLEMET;
    }

    private Guillemet(String start, String end) {
        this.start = start;
        this.end = end;
    }

    public String manageGuillemet(String st) {
        if (this == DOUBLE_COMPARATOR) {
            return st;
        }
        return st.replaceAll("\\<\\<\\s?((?:\\<&\\w+\\>|[^<>])+?)\\s?\\>\\>", Matcher.quoteReplacement(this.start) + "$1" + Matcher.quoteReplacement(this.end));
    }

    public String manageGuillemetStrict(String st) {
        if (this == DOUBLE_COMPARATOR) {
            return st;
        }
        if (st.startsWith("<< ")) {
            st = this.start + st.substring(3);
        } else if (st.startsWith("<<")) {
            st = this.start + st.substring(2);
        }
        if (st.endsWith(" >>")) {
            st = st.substring(0, st.length() - 3) + this.end;
        } else if (st.endsWith(">>")) {
            st = st.substring(0, st.length() - 2) + this.end;
        }
        return st;
    }
}

