/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram.command;

import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.sequencediagram.command.CommandArrow;
import znaishaded.net.sourceforge.plantuml.skin.ArrowConfiguration;
import znaishaded.net.sourceforge.plantuml.timingdiagram.Player;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeTick;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingDiagram;
import znaishaded.net.sourceforge.plantuml.timingdiagram.command.TimeTickBuilder;
import znaishaded.net.sourceforge.plantuml.utils.LineLocation;

public class CommandConstraint
extends SingleLineCommand2<TimingDiagram> {
    public CommandConstraint() {
        super(CommandConstraint.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandConstraint.class.getName(), RegexLeaf.start(), new RegexLeaf("PART1", "(([\\p{L}_][%pLN_.]*))?"), TimeTickBuilder.expressionAtWithArobase("TIME1"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\<"), new RegexLeaf("(-+)"), new RegexLeaf("ARROW_STYLE1", CommandArrow.getColorOrStylePattern()), new RegexLeaf("(-*)"), new RegexLeaf("\\>"), RegexLeaf.spaceZeroOrMore(), TimeTickBuilder.expressionAtWithArobase("TIME2"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("MESSAGE", "(.*)"))), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        TimeTick tick1;
        Player player1;
        String part1 = arg.get("PART1", 0);
        if (part1 == null) {
            player1 = diagram.getLastPlayer();
            if (player1 == null) {
                return CommandExecutionResult.error("You have to provide a participant");
            }
        } else {
            player1 = diagram.getPlayer(part1);
            if (player1 == null) {
                return CommandExecutionResult.error("No such participant " + part1);
            }
        }
        if ((tick1 = TimeTickBuilder.parseTimeTick("TIME1", arg, diagram)) == null) {
            return CommandExecutionResult.error("Unknown time label");
        }
        TimeTick restore = diagram.getNow();
        diagram.updateNow(tick1);
        TimeTick tick2 = TimeTickBuilder.parseTimeTick("TIME2", arg, diagram);
        diagram.updateNow(restore);
        if (tick2 == null) {
            return CommandExecutionResult.error("Unknown time label");
        }
        ArrowConfiguration config = ArrowConfiguration.withDirectionBoth();
        config = CommandArrow.applyStyle(arg.getLazzy("ARROW_STYLE", 0), config);
        player1.createConstraint(tick1, tick2, arg.get("MESSAGE", 0), config);
        return CommandExecutionResult.ok();
    }
}

