/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.parser;

import java.util.HashMap;
import java.util.Map;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenCompound;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenDescription;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenParameter;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenParameterList;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenUtils;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;

public class DoxygenMember {
    private final DoxygenParameterList parameters = new DoxygenParameterList();
    private final DoxygenParameterList templateParameters = new DoxygenParameterList();
    private DoxygenCompound compound;
    private String id;
    private String name;
    private String declType;
    private ApiLinkedText returnType;
    private DoxygenDescription description;
    private String visibility;
    private String kind;
    private String normalizedParamsSignature;
    private boolean isVirtual;
    private boolean isStatic;
    private boolean isConst;
    private boolean isNoExcept;

    public DoxygenDescription getDescription() {
        return this.description;
    }

    public void setDescription(DoxygenDescription description) {
        this.description = description;
    }

    public void addParameter(String name, ApiLinkedText type) {
        this.parameters.add(new DoxygenParameter(name, type));
    }

    public String getNormalizedParamsSignature() {
        return this.normalizedParamsSignature;
    }

    protected void buildNormalizedParamsSignature() {
        this.normalizedParamsSignature = this.parameters.generateCommaSeparatedTypes();
    }

    public void addTemplateParameter(String name, ApiLinkedText type) {
        if (type.contains("doc_ignore")) {
            return;
        }
        this.templateParameters.add(new DoxygenParameter(name, type));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DoxygenCompound getCompound() {
        return this.compound;
    }

    public void setCompound(DoxygenCompound compound) {
        this.compound = compound;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDeclType() {
        return this.declType;
    }

    public void setDeclType(String declType) {
        this.declType = declType;
    }

    public boolean matchesArgs(String normalizedArgsToMatch) {
        return this.normalizedParamsSignature.equals(normalizedArgsToMatch);
    }

    public String getFullName() {
        return DoxygenUtils.fullName(this.compound.getKind(), this.compound.getName(), this.name);
    }

    public ApiLinkedText getReturnType() {
        return this.returnType;
    }

    public void setReturnType(ApiLinkedText returnType) {
        this.returnType = returnType;
    }

    public DoxygenParameterList getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public void setConst(boolean aConst) {
        this.isConst = aConst;
    }

    public boolean isNoExcept() {
        return this.isNoExcept;
    }

    public void setNoExcept(boolean noExcept) {
        this.isNoExcept = noExcept;
    }

    public boolean isPublic() {
        return "public".equals(this.visibility);
    }

    public boolean isProtected() {
        return "protected".equals(this.visibility);
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public boolean isVariable() {
        return "variable".equals(this.kind);
    }

    public boolean isFunction() {
        return "function".equals(this.kind);
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void setVirtual(boolean virtual) {
        this.isVirtual = virtual;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean aStatic) {
        this.isStatic = aStatic;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("compoundName", DoxygenUtils.compoundNameOrEmptyForFile(this.compound.getKind(), this.compound.getName()));
        result.put("compoundKind", this.compound.getKind());
        result.put("name", this.name);
        result.put("visibility", this.visibility);
        result.put("kind", this.kind);
        result.put("declType", this.declType);
        result.put("isVirtual", this.isVirtual);
        result.put("isFunction", this.isFunction());
        result.put("isConst", this.isConst);
        result.put("isNoExcept", this.isNoExcept);
        result.put("isStatic", this.isStatic);
        result.put("returnType", this.returnType.toListOfMaps());
        result.put("parameters", this.parameters.toListOfMaps());
        result.put("templateParameters", this.templateParameters.toListOfMaps());
        return result;
    }
}

