/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server.sockets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.server.sockets.WebSocketHandler;
import org.testingisdocumenting.znai.utils.JsonUtils;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.http.ServerWebSocket;

public abstract class JsonWebSocketHandler
implements WebSocketHandler {
    protected final List<SocketWithUrl> sockets = new ArrayList<SocketWithUrl>();
    private final String name;
    private final String url;
    private final Consumer<String> onMessageHandler;
    protected Vertx vertx;

    public JsonWebSocketHandler(String name, String url, Consumer<String> onMessageHandler) {
        this.name = name;
        this.url = url;
        this.onMessageHandler = onMessageHandler;
    }

    public abstract void onConnect(String var1);

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public void init(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public boolean handles(ServerWebSocket ws) {
        return ws.uri().startsWith(this.url);
    }

    @Override
    public void handle(ServerWebSocket ws) {
        if (!this.handles(ws)) {
            return;
        }
        this.sockets.add(new SocketWithUrl(ws, ws.uri()));
        ConsoleOutputs.out(new Object[]{this.name + " connected: ", Color.BLUE, ws.path()});
        this.renderNumberOfSockets();
        this.onConnect(ws.uri());
        ws.handler(data -> {
            String dataString = data.getString(0, data.length());
            try {
                this.onMessageHandler.accept(dataString);
            }
            catch (Throwable t) {
                ConsoleOutputs.err(t.toString());
            }
        });
        ws.closeHandler(h2 -> {
            this.sockets.removeIf(s2 -> s2.socket == ws);
            ConsoleOutputs.out(new Object[]{Color.RED, this.name + " connection closed"});
            this.renderNumberOfSockets();
        });
    }

    public void send(String subUrlToContain, Map<String, ?> payload) {
        if (this.sockets.isEmpty()) {
            return;
        }
        String payloadAsText = JsonUtils.serialize(payload);
        this.sockets.stream().filter(s2 -> s2.connectedUrl.contains(subUrlToContain)).forEach(s2 -> s2.socket.writeFinalTextFrame(payloadAsText));
    }

    private void renderNumberOfSockets() {
        ConsoleOutputs.out("there are " + this.sockets.size() + " opened sockets for " + this.name);
    }

    protected record SocketWithUrl(ServerWebSocket socket, String connectedUrl) {
    }
}

