/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.keyword.validator.draftv4;

import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.node.ObjectNode;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.processing.Processor;
import znaishaded.com.github.fge.jsonschema.core.report.ListProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.report.LogLevel;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import znaishaded.com.github.fge.jsonschema.keyword.validator.helpers.SchemaArrayValidator;
import znaishaded.com.github.fge.jsonschema.processors.data.FullData;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;

public final class OneOfValidator
extends SchemaArrayValidator {
    public OneOfValidator(JsonNode digest) {
        super("oneOf");
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        SchemaTree tree = data.getSchema();
        JsonPointer schemaPointer = tree.getPointer();
        JsonNode schemas = tree.getNode().get(this.keyword);
        int size = schemas.size();
        ObjectNode fullReport = FACTORY.objectNode();
        int nrSuccess = 0;
        for (int index = 0; index < size; ++index) {
            ListProcessingReport subReport = new ListProcessingReport(report.getLogLevel(), LogLevel.FATAL);
            JsonPointer ptr = schemaPointer.append(JsonPointer.of(this.keyword, index));
            FullData newData = data.withSchema(tree.setPointer(ptr));
            processor.process(subReport, newData);
            fullReport.set(ptr.toString(), subReport.asJson());
            if (!subReport.isSuccess()) continue;
            ++nrSuccess;
        }
        if (nrSuccess != 1) {
            report.error(this.newMsg(data, bundle, "err.draftv4.oneOf.fail").putArgument("matched", nrSuccess).putArgument("nrSchemas", size).put("reports", fullReport));
        }
    }
}

