/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.processors.data;

import javax.annotation.concurrent.Immutable;
import znaishaded.com.github.fge.jsonschema.core.report.MessageProvider;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingMessage;
import znaishaded.com.github.fge.jsonschema.core.tree.JsonTree;
import znaishaded.com.github.fge.jsonschema.core.tree.SchemaTree;

@Immutable
public final class FullData
implements MessageProvider {
    private final SchemaTree schema;
    private final JsonTree instance;
    private final boolean deepCheck;

    public FullData(SchemaTree schema, JsonTree instance, boolean deepCheck) {
        this.schema = schema;
        this.instance = instance;
        this.deepCheck = deepCheck;
    }

    public FullData(SchemaTree schema, JsonTree instance) {
        this(schema, instance, false);
    }

    @Deprecated
    public FullData(SchemaTree schema) {
        this(schema, null);
    }

    public SchemaTree getSchema() {
        return this.schema;
    }

    public JsonTree getInstance() {
        return this.instance;
    }

    public boolean isDeepCheck() {
        return this.deepCheck;
    }

    public FullData withSchema(SchemaTree schema) {
        return new FullData(schema, this.instance, this.deepCheck);
    }

    public FullData withInstance(JsonTree instance) {
        return new FullData(this.schema, instance, this.deepCheck);
    }

    @Override
    public ProcessingMessage newMessage() {
        ProcessingMessage ret = new ProcessingMessage();
        if (this.schema != null) {
            ret.put("schema", this.schema);
        }
        if (this.instance != null) {
            ret.put("instance", this.instance);
        }
        return ret;
    }
}

