/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.ext.jython;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import znaishaded.freemarker.ext.beans.BeansWrapper;
import znaishaded.freemarker.ext.beans.DateModel;
import znaishaded.freemarker.ext.jython.JythonHashModel;
import znaishaded.freemarker.ext.jython.JythonModel;
import znaishaded.freemarker.ext.jython.JythonNumberModel;
import znaishaded.freemarker.ext.jython.JythonSequenceModel;
import znaishaded.freemarker.ext.jython.JythonVersionAdapter;
import znaishaded.freemarker.ext.jython.JythonVersionAdapterHolder;
import znaishaded.freemarker.ext.jython.JythonWrapper;
import znaishaded.freemarker.ext.util.ModelCache;
import znaishaded.freemarker.template.TemplateModel;
import znaishaded.org.python.core.Py;
import znaishaded.org.python.core.PyDictionary;
import znaishaded.org.python.core.PyFloat;
import znaishaded.org.python.core.PyInteger;
import znaishaded.org.python.core.PyLong;
import znaishaded.org.python.core.PyNone;
import znaishaded.org.python.core.PyObject;
import znaishaded.org.python.core.PySequence;
import znaishaded.org.python.core.PyStringMap;

class JythonModelCache
extends ModelCache {
    private final JythonWrapper wrapper;

    JythonModelCache(JythonWrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    protected boolean isCacheable(Object object) {
        return true;
    }

    @Override
    protected TemplateModel create(Object obj) {
        boolean asHash = false;
        boolean asSequence = false;
        JythonVersionAdapter versionAdapter = JythonVersionAdapterHolder.INSTANCE;
        if (versionAdapter.isPyInstance(obj)) {
            Object jobj = versionAdapter.pyInstanceToJava(obj);
            if (jobj instanceof TemplateModel) {
                return (TemplateModel)jobj;
            }
            if (jobj instanceof Map) {
                asHash = true;
            }
            if (jobj instanceof Date) {
                return new DateModel((Date)jobj, BeansWrapper.getDefaultInstance());
            }
            if (jobj instanceof Collection) {
                asSequence = true;
                if (!(jobj instanceof List)) {
                    obj = new ArrayList((Collection)jobj);
                }
            }
        }
        if (!(obj instanceof PyObject)) {
            obj = Py.java2py((Object)obj);
        }
        if (asHash || obj instanceof PyDictionary || obj instanceof PyStringMap) {
            return JythonHashModel.FACTORY.create(obj, this.wrapper);
        }
        if (asSequence || obj instanceof PySequence) {
            return JythonSequenceModel.FACTORY.create(obj, this.wrapper);
        }
        if (obj instanceof PyInteger || obj instanceof PyLong || obj instanceof PyFloat) {
            return JythonNumberModel.FACTORY.create(obj, this.wrapper);
        }
        if (obj instanceof PyNone) {
            return null;
        }
        return JythonModel.FACTORY.create(obj, this.wrapper);
    }
}

