/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.v3.parser.processors;

import java.util.List;
import znaishaded.io.swagger.v3.oas.models.OpenAPI;
import znaishaded.io.swagger.v3.oas.models.examples.Example;
import znaishaded.io.swagger.v3.parser.ResolverCache;
import znaishaded.io.swagger.v3.parser.models.RefFormat;
import znaishaded.io.swagger.v3.parser.processors.ExternalRefProcessor;
import znaishaded.io.swagger.v3.parser.util.RefUtils;

public class ExampleProcessor {
    private final ResolverCache cache;
    private final OpenAPI openAPI;
    private final ExternalRefProcessor externalRefProcessor;

    public ExampleProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.openAPI = openAPI;
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processExample(Example example) {
        if (example.get$ref() != null) {
            this.processReferenceExample(example);
        }
    }

    public void processExample(List<Example> examples) {
        for (Example example : examples) {
            if (example.get$ref() == null) continue;
            this.processReferenceExample(example);
        }
    }

    private void processReferenceExample(Example example) {
        String newRef;
        RefFormat refFormat = RefUtils.computeRefFormat(example.get$ref());
        String $ref = example.get$ref();
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalExample($ref, refFormat)) != null) {
            example.set$ref(newRef);
        }
    }
}

