/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.asciiart;

import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.asciiart.AbstractComponentText;
import znaishaded.net.sourceforge.plantuml.asciiart.UmlCharArea;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.txt.UGraphicTxt;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;

public class ComponentTextNote
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;

    public ComponentTextNote(ComponentType type, Display stringsToDisplay, FileFormat fileFormat) {
        this.type = type;
        this.stringsToDisplay = stringsToDisplay;
        this.fileFormat = fileFormat;
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        XDimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth() - 1;
        int height = (int)dimensionToUse.getHeight();
        charArea.fillRect(' ', 2, 1, width - 3, height - 2);
        if (this.type == ComponentType.NOTE) {
            if (this.fileFormat == FileFormat.UTXT) {
                charArea.drawNoteSimpleUnicode(2, 0, width - 2, height);
            } else {
                charArea.drawNoteSimple(2, 0, width - 2, height);
            }
        } else if (this.type == ComponentType.NOTE_BOX || this.type == ComponentType.NOTE_HEXAGONAL) {
            if (this.fileFormat == FileFormat.UTXT) {
                charArea.drawBoxSimpleUnicode(2, 0, width - 2, height);
            } else {
                charArea.drawBoxSimple(2, 0, width - 2, height);
            }
        }
        if (this.fileFormat == FileFormat.UTXT) {
            charArea.drawStringsLRUnicode(this.stringsToDisplay.asList(), 3, 1);
        } else {
            charArea.drawStringsLRSimple(this.stringsToDisplay.asList(), 3, 1);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 2;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWcWidth(this.stringsToDisplay) + 7;
    }
}

