/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.bpm;

import znaishaded.net.sourceforge.plantuml.bpm.BpmElement;
import znaishaded.net.sourceforge.plantuml.bpm.Cell;
import znaishaded.net.sourceforge.plantuml.bpm.Col;
import znaishaded.net.sourceforge.plantuml.bpm.ConnectorPuzzle;
import znaishaded.net.sourceforge.plantuml.bpm.ConnectorPuzzleEmpty;
import znaishaded.net.sourceforge.plantuml.bpm.Grid;
import znaishaded.net.sourceforge.plantuml.bpm.GridCleaner;
import znaishaded.net.sourceforge.plantuml.bpm.Line;
import znaishaded.net.sourceforge.plantuml.bpm.Placeable;

public class CleanerInterleavingLines
implements GridCleaner {
    @Override
    public boolean clean(Grid grid) {
        boolean result = false;
        Line previous = null;
        for (Line line : grid.lines().toList()) {
            if (previous != null && this.mergeable(grid, previous, line)) {
                this.mergeLines(grid, previous, line);
                return true;
            }
            previous = line;
        }
        return result;
    }

    private void mergeLines(Grid grid, Line line1, Line line2) {
        for (Col col : grid.cols().toList()) {
            Cell cell1 = grid.getCell(line1, col);
            Cell cell2 = grid.getCell(line2, col);
            cell1.setData(this.merge(cell1.getData(), cell2.getData()));
            cell2.setData(null);
        }
        grid.removeLine(line2);
    }

    private boolean mergeable(Grid grid, Line line1, Line line2) {
        for (Col col : grid.cols().toList()) {
            Placeable cell2;
            Placeable cell1 = grid.getCell(line1, col).getData();
            if (this.mergeable(cell1, cell2 = grid.getCell(line2, col).getData())) continue;
            return false;
        }
        return true;
    }

    private Placeable merge(Placeable data1, Placeable data2) {
        if (data1 == null) {
            return data2;
        }
        if (data2 == null) {
            return data1;
        }
        assert (data1 != null && data2 != null);
        if (data1 instanceof BpmElement) {
            return data1;
        }
        if (data2 instanceof BpmElement) {
            ConnectorPuzzleEmpty puz1 = (ConnectorPuzzleEmpty)data1;
            if (puz1.checkDirections("SW")) {
                ((BpmElement)data2).remove(ConnectorPuzzle.Where.NORTH);
                ((BpmElement)data2).append(ConnectorPuzzle.Where.WEST);
            }
            return data2;
        }
        assert (data1 instanceof ConnectorPuzzleEmpty && data2 instanceof ConnectorPuzzleEmpty);
        ConnectorPuzzleEmpty puz1 = (ConnectorPuzzleEmpty)data1;
        ConnectorPuzzleEmpty puz2 = (ConnectorPuzzleEmpty)data2;
        return puz2;
    }

    private boolean mergeable(Placeable data1, Placeable data2) {
        if (data1 == null || data2 == null) {
            return true;
        }
        assert (data1 != null && data2 != null);
        if (data1 instanceof ConnectorPuzzleEmpty && data2 instanceof ConnectorPuzzleEmpty) {
            return this.mergeableCC((ConnectorPuzzleEmpty)data1, (ConnectorPuzzleEmpty)data2);
        }
        if (data1 instanceof ConnectorPuzzleEmpty && data2 instanceof BpmElement) {
            boolean result = this.mergeablePuzzleSingle((ConnectorPuzzleEmpty)data1, (BpmElement)data2);
            return result;
        }
        if (data2 instanceof ConnectorPuzzleEmpty && data1 instanceof BpmElement) {
            boolean result = this.mergeablePuzzleSingle((BpmElement)data1, (ConnectorPuzzleEmpty)data2);
            return result;
        }
        return false;
    }

    private boolean mergeablePuzzleSingle(ConnectorPuzzleEmpty data1, BpmElement data2) {
        if (data1.checkDirections("NS")) {
            return true;
        }
        return data1.checkDirections("SW");
    }

    private boolean mergeablePuzzleSingle(BpmElement data1, ConnectorPuzzleEmpty data2) {
        return data2.checkDirections("NS");
    }

    private boolean mergeableCC(ConnectorPuzzleEmpty puz1, ConnectorPuzzleEmpty puz2) {
        if (puz1.checkDirections("NS") && puz2.checkDirections("NS")) {
            return true;
        }
        if (puz1.checkDirections("NS") && puz2.checkDirections("NE")) {
            return true;
        }
        return puz1.checkDirections("NS") && puz2.checkDirections("NW");
    }
}

