/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.TitledDiagram;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilinesBracket;
import znaishaded.net.sourceforge.plantuml.command.SkinLoader;
import znaishaded.net.sourceforge.plantuml.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.utils.BlocLines;

public class CommandSkinParamMultilines
extends CommandMultilinesBracket<TitledDiagram> {
    public static final CommandSkinParamMultilines ME = new CommandSkinParamMultilines();

    private CommandSkinParamMultilines() {
        super("^skinparam[%s]*(?:[%s]+([\\w.]*(?:\\<\\<.*\\>\\>)?[\\w.]*))?[%s]*\\{$");
    }

    @Override
    protected boolean isLineConsistent(String line, int level) {
        if (this.hasStartingQuote(line = StringUtils.trin(line))) {
            return true;
        }
        return SkinLoader.p1.matcher(line).matches();
    }

    private boolean hasStartingQuote(CharSequence line) {
        return MyPattern.mtches(line, "^[%s]*([%q].*||/[%q].*[%q]/[%s]*)$");
    }

    @Override
    public CommandExecutionResult execute(TitledDiagram diagram, BlocLines lines) {
        SkinLoader skinLoader = new SkinLoader(diagram);
        Matcher2 mStart = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        if (!mStart.find()) {
            throw new IllegalStateException();
        }
        String group1 = mStart.group(1);
        return skinLoader.execute(lines, group1);
    }
}

