/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.decoration.symbol;

import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbol;
import znaishaded.net.sourceforge.plantuml.klimt.Fashion;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UPolygon;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.style.SName;

class USymbolArtifact
extends USymbol {
    USymbolArtifact() {
    }

    @Override
    public SName getSName() {
        return SName.artifact;
    }

    private void drawArtifact(UGraphic ug, double widthTotal, double heightTotal, double shadowing, double roundCorner) {
        URectangle form = URectangle.build(widthTotal, heightTotal).rounded(roundCorner);
        form.setDeltaShadow(shadowing);
        ug.draw(form);
        UPolygon polygon = new UPolygon();
        polygon.addPoint(0.0, 0.0);
        double heightSymbol = 14.0;
        polygon.addPoint(0.0, 14.0);
        double widthSymbol = 12.0;
        polygon.addPoint(12.0, 14.0);
        int cornersize = 6;
        polygon.addPoint(12.0, 6.0);
        polygon.addPoint(6.0, 0.0);
        polygon.addPoint(0.0, 0.0);
        double xSymbol = widthTotal - 12.0 - 5.0;
        double ySymbol = 5.0;
        ug.apply(new UTranslate(xSymbol, 5.0)).draw(polygon);
        ug.apply(new UTranslate(xSymbol + 12.0 - 6.0, 5.0)).draw(ULine.vline(6.0));
        ug.apply(new UTranslate(xSymbol + 12.0, 11.0)).draw(ULine.hline(-6.0));
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 20.0, 13.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dim);
                ug = symbolContext.apply(ug);
                USymbolArtifact.this.drawArtifact(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), symbolContext.getRoundCorner());
                USymbol.Margin margin = USymbolArtifact.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolArtifact.this.getMargin().addDimension(dimStereo.mergeTB(dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolArtifact.this.drawArtifact(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow(), symbolContext.getRoundCorner());
                XDimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                double posStereo = (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(posStereo, 2.0)));
                XDimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0 + dimStereo.getHeight())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }
        };
    }
}

