/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ebnf;

import znaishaded.net.sourceforge.plantuml.ebnf.CornerType;
import znaishaded.net.sourceforge.plantuml.ebnf.ETile;
import znaishaded.net.sourceforge.plantuml.klimt.CopyForegroundColorToBackgroundColor;
import znaishaded.net.sourceforge.plantuml.klimt.UPath;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UDrawable;

public class CornerCurved
implements UDrawable {
    private final double delta;
    private final CornerType type;
    private final boolean withArrow;

    private CornerCurved(CornerType type, double delta, boolean withArrow) {
        this.delta = delta;
        this.type = type;
        this.withArrow = withArrow;
        if (delta <= 0.0) {
            throw new IllegalArgumentException();
        }
    }

    public static UDrawable createSW(double delta) {
        return new CornerCurved(CornerType.SW, delta, false);
    }

    public static UDrawable createSE(double delta) {
        return new CornerCurved(CornerType.SE, delta, false);
    }

    public static UDrawable createNE(double delta) {
        return new CornerCurved(CornerType.NE, delta, false);
    }

    public static UDrawable createNE_arrow(double delta) {
        return new CornerCurved(CornerType.NE, delta, true);
    }

    public static UDrawable createNW(double delta) {
        return new CornerCurved(CornerType.NW, delta, false);
    }

    public static UDrawable createNW_arrow(double delta) {
        return new CornerCurved(CornerType.NW, delta, true);
    }

    @Override
    public void drawU(UGraphic ug) {
        UPath path = UPath.none();
        double a = this.delta / 4.0;
        switch (this.type) {
            case SW: {
                path.moveTo(0.0, -this.delta);
                path.cubicTo(0.0, -a, a, 0.0, this.delta, 0.0);
                break;
            }
            case SE: {
                path.moveTo(0.0, -this.delta);
                path.cubicTo(0.0, -a, -a, 0.0, -this.delta, 0.0);
                break;
            }
            case NE: {
                path.moveTo(-this.delta, 0.0);
                path.cubicTo(-a, 0.0, 0.0, a, 0.0, this.delta);
                if (!this.withArrow) break;
                ug.apply(new CopyForegroundColorToBackgroundColor()).apply(UTranslate.dy(this.delta - 5.0)).draw(ETile.getArrowToBottom());
                break;
            }
            case NW: {
                path.moveTo(0.0, this.delta);
                path.cubicTo(0.0, a, a, 0.0, this.delta, 0.0);
                if (!this.withArrow) break;
                ug.apply(new CopyForegroundColorToBackgroundColor()).apply(UTranslate.dy(this.delta)).draw(ETile.getArrowToTop());
            }
        }
        ug.draw(path);
    }
}

