/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.regex.Pattern2;

public class SvgAttributes {
    private final Map<String, String> attributes = new TreeMap<String, String>();

    private SvgAttributes cloneMe() {
        SvgAttributes result = new SvgAttributes();
        result.attributes.putAll(this.attributes);
        return result;
    }

    private SvgAttributes() {
    }

    public static SvgAttributes empty() {
        return new SvgAttributes();
    }

    public static SvgAttributes build(String args) {
        SvgAttributes result = new SvgAttributes();
        Pattern2 p = MyPattern.cmpile("(\\w+)\\s*=\\s*([%g][^%g]*[%g]|(?:\\w+))");
        Matcher2 m3 = p.matcher(args);
        while (m3.find()) {
            result.attributes.put(m3.group(1), StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(m3.group(2)));
        }
        return result;
    }

    public Map<String, String> attributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public SvgAttributes add(String key, String value) {
        SvgAttributes result = this.cloneMe();
        result.attributes.put(key, value);
        return result;
    }

    public SvgAttributes add(SvgAttributes toBeAdded) {
        SvgAttributes result = this.cloneMe();
        result.attributes.putAll(toBeAdded.attributes);
        return result;
    }
}

