/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole.legacy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Neutron;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Parser;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.Atom;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeRaw;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UText;

public class StripeCode
implements StripeRaw {
    private final FontConfiguration fontConfiguration;
    private final List<String> raw = new ArrayList<String>();
    private boolean terminated;

    public StripeCode(FontConfiguration fontConfiguration) {
        this.fontConfiguration = fontConfiguration;
    }

    @Override
    public List<Atom> getAtoms() {
        return Collections.singletonList(this);
    }

    @Override
    public Atom getLHeader() {
        return null;
    }

    @Override
    public boolean addAndCheckTermination(String line) {
        if (Parser.isCodeEnd(line)) {
            this.terminated = true;
            return true;
        }
        this.raw.add(line);
        return false;
    }

    @Override
    public final boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (String s2 : this.raw) {
            XDimension2D dim = stringBounder.calculateDimension(this.fontConfiguration.getFont(), s2);
            width = Math.max(width, dim.getWidth());
            height += dim.getHeight();
        }
        return new XDimension2D(width, height);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        double y = 0.0;
        for (String s2 : this.raw) {
            UText shape = UText.build(s2, this.fontConfiguration);
            StringBounder stringBounder = ug.getStringBounder();
            XDimension2D dim = stringBounder.calculateDimension(this.fontConfiguration.getFont(), s2);
            ug.apply(UTranslate.dy((y += dim.getHeight()) - shape.getDescent(stringBounder))).draw(shape);
        }
    }

    @Override
    public List<Neutron> getNeutrons() {
        return Arrays.asList(Neutron.create(this));
    }
}

