/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.shape;

import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UEllipse;
import znaishaded.net.sourceforge.plantuml.svek.image.ContainingEllipse;
import znaishaded.net.sourceforge.plantuml.svek.image.Footprint;

public class TextBlockInEllipse
extends AbstractTextBlock
implements TextBlock {
    private final TextBlock text;
    private final ContainingEllipse ellipse;

    public TextBlockInEllipse(TextBlock text, StringBounder stringBounder) {
        this.text = text;
        XDimension2D textDim = text.calculateDimension(stringBounder);
        double alpha = textDim.getHeight() / textDim.getWidth();
        if (alpha < 0.2) {
            alpha = 0.2;
        } else if (alpha > 0.8) {
            alpha = 0.8;
        }
        Footprint footprint = new Footprint(stringBounder);
        this.ellipse = footprint.getEllipse(text, alpha);
    }

    public UEllipse getUEllipse() {
        return this.ellipse.asUEllipse().bigger(6.0);
    }

    @Override
    public void drawU(UGraphic ug) {
        UEllipse sh = this.getUEllipse();
        XPoint2D center = this.ellipse.getCenter();
        double dx = sh.getWidth() / 2.0 - center.getX();
        double dy = sh.getHeight() / 2.0 - center.getY();
        ug.draw(sh);
        this.text.drawU(ug.apply(new UTranslate(dx, dy - 2.0)));
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.getUEllipse().getDimension();
    }

    public void setDeltaShadow(double deltaShadow) {
        this.ellipse.setDeltaShadow(deltaShadow);
    }
}

