/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.project.DayStatus;
import znaishaded.net.sourceforge.plantuml.project.LoadPlanable;
import znaishaded.net.sourceforge.plantuml.project.core3.Histogram;
import znaishaded.net.sourceforge.plantuml.project.core3.TimeLine;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.time.DayOfWeek;

public class OpenClose
implements Histogram,
LoadPlanable {
    private final Map<DayOfWeek, DayStatus> weekdayStatus = new EnumMap<DayOfWeek, DayStatus>(DayOfWeek.class);
    private final Map<Day, DayStatus> dayStatus = new HashMap<Day, DayStatus>();
    private Day startingDay;

    public int daysInWeek() {
        int result = 7;
        for (DayStatus status : this.weekdayStatus.values()) {
            if (status != DayStatus.CLOSE) continue;
            --result;
        }
        return result;
    }

    private boolean isThereSomeChangeAfter(Day day) {
        if (this.weekdayStatus.size() > 0) {
            return true;
        }
        for (Day tmp : this.dayStatus.keySet()) {
            if (tmp.compareTo(day) < 0) continue;
            return true;
        }
        return false;
    }

    private boolean isThereSomeChangeBefore(Day day) {
        if (this.weekdayStatus.size() > 0) {
            return true;
        }
        for (Day tmp : this.dayStatus.keySet()) {
            if (tmp.compareTo(day) > 0) continue;
            return true;
        }
        return false;
    }

    public boolean isClosed(Day day) {
        DayStatus status = this.getLocalStatus(day);
        if (status != null) {
            return status == DayStatus.CLOSE;
        }
        return false;
    }

    private DayStatus getLocalStatus(Day day) {
        DayStatus status1 = this.dayStatus.get(day);
        if (status1 != null) {
            return status1;
        }
        DayOfWeek dayOfWeek = day.getDayOfWeek();
        DayStatus status2 = this.weekdayStatus.get((Object)dayOfWeek);
        if (status2 != null) {
            return status2;
        }
        return null;
    }

    public void close(DayOfWeek day) {
        this.weekdayStatus.put(day, DayStatus.CLOSE);
    }

    public void open(DayOfWeek day) {
        this.weekdayStatus.put(day, DayStatus.OPEN);
    }

    public void close(Day day) {
        this.dayStatus.put(day, DayStatus.CLOSE);
    }

    public void open(Day day) {
        this.dayStatus.put(day, DayStatus.OPEN);
    }

    public final Day getStartingDay() {
        return this.startingDay;
    }

    public final void setStartingDay(Day startingDay) {
        this.startingDay = startingDay;
    }

    @Override
    public long getNext(long moment) {
        int tmp;
        Day day = Day.create(moment);
        if (!this.isThereSomeChangeAfter(day)) {
            return TimeLine.MAX_TIME;
        }
        long current = this.getLoatAtInternal(day);
        System.err.println("getNext:day=" + day + " current=" + current);
        do {
            day = day.increment();
            tmp = this.getLoatAtInternal(day);
            System.err.println("..day=" + day + " " + tmp);
        } while ((long)tmp == current);
        return day.getMillis();
    }

    @Override
    public long getPrevious(long moment) {
        int tmp;
        Day day = Day.create(moment);
        if (!this.isThereSomeChangeBefore(day)) {
            return -TimeLine.MAX_TIME.longValue();
        }
        long current = this.getLoatAtInternal(day);
        System.err.println("getPrevious=" + day + " current=" + current);
        do {
            day = day.decrement();
            tmp = this.getLoatAtInternal(day);
            System.err.println("..day=" + day + " " + tmp);
        } while ((long)tmp == current);
        return day.getMillis();
    }

    @Override
    public long getValueAt(long moment) {
        Day day = Day.create(moment);
        if (this.isClosed(day)) {
            return 0L;
        }
        return 100L;
    }

    @Override
    public int getLoadAt(Day day) {
        if (this.getStartingDay() == null) {
            return 100;
        }
        return this.getLoatAtInternal(day);
    }

    private int getLoatAtInternal(Day day) {
        if (this.isClosed(day)) {
            return 0;
        }
        return 100;
    }

    public LoadPlanable mutateMe(final OpenClose except) {
        if (except != null) {
            return new LoadPlanable(){

                @Override
                public int getLoadAt(Day instant) {
                    DayStatus exceptStatus = except.getLocalStatus(instant);
                    if (exceptStatus == DayStatus.CLOSE) {
                        return 0;
                    }
                    if (exceptStatus == DayStatus.OPEN) {
                        return 100;
                    }
                    return OpenClose.this.getLoadAt(instant);
                }
            };
        }
        return this;
    }
}

