/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.project.Failable;
import znaishaded.net.sourceforge.plantuml.project.GanttDiagram;
import znaishaded.net.sourceforge.plantuml.project.lang.CenterBorderColor;
import znaishaded.net.sourceforge.plantuml.project.lang.ComplementClose;
import znaishaded.net.sourceforge.plantuml.project.lang.ComplementInColors2;
import znaishaded.net.sourceforge.plantuml.project.lang.ComplementOpen;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceSimple;
import znaishaded.net.sourceforge.plantuml.project.lang.Subject;
import znaishaded.net.sourceforge.plantuml.project.lang.Verbs;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;

public class SubjectDayAsDate
implements Subject {
    public static final Subject ME = new SubjectDayAsDate();

    private SubjectDayAsDate() {
    }

    public Failable<Day> getMe(GanttDiagram project, RegexResult arg) {
        if (arg.get("BDAY", 0) != null) {
            return Failable.ok(this.resultB(arg));
        }
        if (arg.get("ECOUNT", 0) != null) {
            return Failable.ok(this.resultE(project, arg));
        }
        throw new IllegalStateException();
    }

    private Day resultB(RegexResult arg) {
        int day = Integer.parseInt(arg.get("BDAY", 0));
        int month = Integer.parseInt(arg.get("BMONTH", 0));
        int year = Integer.parseInt(arg.get("BYEAR", 0));
        return Day.create(year, month, day);
    }

    private Day resultE(GanttDiagram system, RegexResult arg) {
        String type = arg.get("ETYPE", 0).toUpperCase();
        String operation = arg.get("EOPERATION", 0);
        int day = Integer.parseInt(arg.get("ECOUNT", 0));
        if ("-".equals(operation)) {
            day = -day;
        }
        if ("D".equals(type)) {
            return system.getStartingDate().addDays(day);
        }
        if ("T".equals(type)) {
            return system.getToday().addDays(day);
        }
        if ("E".equals(type)) {
            return system.getEndingDate().addDays(day);
        }
        throw new IllegalStateException();
    }

    @Override
    public Collection<? extends SentenceSimple> getSentences() {
        return Arrays.asList(new Close(), new Open(), new InColor());
    }

    @Override
    public IRegex toRegex() {
        return new RegexOr(this.toRegexB(), this.toRegexE());
    }

    private IRegex toRegexB() {
        return new RegexConcat(new RegexLeaf("BYEAR", "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("BMONTH", "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("BDAY", "([\\d]{1,2})"));
    }

    private IRegex toRegexE() {
        return new RegexConcat(new RegexLeaf("ETYPE", "([dDtTeE])"), new RegexLeaf("EOPERATION", "([-+])"), new RegexLeaf("ECOUNT", "([\\d]+)"));
    }

    class Close
    extends SentenceSimple {
        public Close() {
            super(SubjectDayAsDate.this, Verbs.isOrAre, new ComplementClose());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            project.closeDayAsDate((Day)subject, (String)complement);
            return CommandExecutionResult.ok();
        }
    }

    class Open
    extends SentenceSimple {
        public Open() {
            super(SubjectDayAsDate.this, Verbs.isOrAre, new ComplementOpen());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            project.openDayAsDate((Day)subject, (String)complement);
            return CommandExecutionResult.ok();
        }
    }

    class InColor
    extends SentenceSimple {
        public InColor() {
            super(SubjectDayAsDate.this, Verbs.isOrAre, new ComplementInColors2());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            HColor color = ((CenterBorderColor)complement).getCenter();
            project.colorDay((Day)subject, color);
            return CommandExecutionResult.ok();
        }
    }
}

