/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.Constraint;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBoxSimple;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.Pushable;

public class ConstraintSet {
    private final ParticipantBoxSimple firstBorder;
    private final ParticipantBoxSimple lastborder;
    private final List<Pushable> participantList = new ArrayList<Pushable>();
    private final Map<List<Pushable>, Constraint> constraints = new HashMap<List<Pushable>, Constraint>();

    public ConstraintSet(Collection<? extends Pushable> all, double freeX) {
        this.firstBorder = new ParticipantBoxSimple(0.0, "LEFT");
        this.participantList.add(this.firstBorder);
        this.participantList.addAll(all);
        this.lastborder = new ParticipantBoxSimple(freeX, "RIGHT");
        this.participantList.add(this.lastborder);
    }

    public String toString() {
        return this.constraints.values().toString();
    }

    public double getMaxX() {
        return this.lastborder.getCenterX(null);
    }

    public Constraint getConstraint(Pushable p1, Pushable p2) {
        if (p1 == null || p2 == null || p1 == p2) {
            throw new IllegalArgumentException();
        }
        int i1 = this.participantList.indexOf(p1);
        int i2 = this.participantList.indexOf(p2);
        if (i1 == -1 || i2 == -1) {
            throw new IllegalArgumentException();
        }
        if (i1 > i2) {
            return this.getConstraint(p2, p1);
        }
        List<Pushable> key = Arrays.asList(p1, p2);
        Constraint result = this.constraints.get(key);
        if (result == null) {
            result = new Constraint(p1, p2);
            this.constraints.put(key, result);
        }
        return result;
    }

    public Constraint getConstraintAfter(Pushable p1) {
        return this.getConstraint(Objects.requireNonNull(p1), this.getNext(p1));
    }

    public Constraint getConstraintBefore(Pushable p1) {
        return this.getConstraint(Objects.requireNonNull(p1), this.getPrevious(p1));
    }

    public Pushable getPrevious(Pushable p) {
        return this.getOtherParticipant(p, -1);
    }

    public Pushable getNext(Pushable p) {
        return this.getOtherParticipant(p, 1);
    }

    private Pushable getOtherParticipant(Pushable p, int delta) {
        int i = this.participantList.indexOf(p);
        if (i == -1) {
            throw new IllegalArgumentException();
        }
        return this.participantList.get(i + delta);
    }

    public void takeConstraintIntoAccount(StringBounder stringBounder) {
        for (int dist = 1; dist < this.participantList.size(); ++dist) {
            this.pushEverybody(stringBounder, dist);
        }
    }

    private void pushEverybody(StringBounder stringBounder, int dist) {
        for (int i = 0; i < this.participantList.size() - dist; ++i) {
            Pushable p1 = this.participantList.get(i);
            Pushable p2 = this.participantList.get(i + dist);
            Constraint c = this.getConstraint(p1, p2);
            this.ensureSpaceAfter(stringBounder, p1, p2, c.getValue());
        }
    }

    public void pushToLeftParticipantBox(double deltaX, Pushable firstToChange, boolean including) {
        if (deltaX <= 0.0) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(firstToChange);
        boolean founded = false;
        for (Pushable box : this.participantList) {
            if (box.equals(firstToChange)) {
                founded = true;
                if (!including) continue;
            }
            if (!founded) continue;
            box.pushToLeft(deltaX);
        }
    }

    public void pushToLeft(double delta) {
        this.pushToLeftParticipantBox(delta, this.firstBorder, true);
    }

    private void ensureSpaceAfter(StringBounder stringBounder, Pushable p1, Pushable p2, double space) {
        if (p1.equals(p2)) {
            throw new IllegalArgumentException();
        }
        if (p1.getCenterX(stringBounder) > p2.getCenterX(stringBounder)) {
            this.ensureSpaceAfter(stringBounder, p2, p1, space);
            return;
        }
        assert (p1.getCenterX(stringBounder) < p2.getCenterX(stringBounder));
        double existingSpace = p2.getCenterX(stringBounder) - p1.getCenterX(stringBounder);
        if (existingSpace < space) {
            this.pushToLeftParticipantBox(space - existingSpace, p2, true);
        }
    }

    public final Pushable getFirstBorder() {
        return this.firstBorder;
    }

    public final Pushable getLastborder() {
        return this.lastborder;
    }
}

