/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Margins;
import znaishaded.net.sourceforge.plantuml.svek.RoundedContainer;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageState;
import znaishaded.net.sourceforge.plantuml.url.Url;

public final class InnerStateAutonom
extends AbstractTextBlock
implements IEntityImage {
    private final IEntityImage im;
    private final TextBlock title;
    private final TextBlock attribute;
    private final HColor borderColor;
    private final HColor backColor;
    private final Url url;
    private final boolean withSymbol;
    private final UStroke stroke;
    private final double rounded;
    private final double shadowing;
    private final HColor bodyColor;

    public InnerStateAutonom(IEntityImage im, TextBlock title, TextBlock attribute, HColor borderColor, HColor backColor, Url url, boolean withSymbol, UStroke stroke, double rounded, double shadowing, HColor bodyColor) {
        this.im = Objects.requireNonNull(im);
        this.withSymbol = withSymbol;
        this.title = title;
        this.borderColor = borderColor;
        this.backColor = backColor;
        this.shadowing = shadowing;
        this.attribute = attribute;
        this.url = url;
        this.stroke = stroke;
        this.rounded = rounded;
        this.bodyColor = bodyColor;
    }

    @Override
    public void drawU(UGraphic ug) {
        XDimension2D text = this.title.calculateDimension(ug.getStringBounder());
        XDimension2D attr = this.attribute.calculateDimension(ug.getStringBounder());
        XDimension2D total = this.calculateDimension(ug.getStringBounder());
        double marginForFields = attr.getHeight() > 0.0 ? 5.0 : 0.0;
        double titreHeight = 5.0 + text.getHeight() + 5.0;
        RoundedContainer r = new RoundedContainer(total, titreHeight, attr.getHeight() + marginForFields, this.borderColor, this.backColor, this.bodyColor, this.stroke, this.rounded, this.shadowing);
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        r.drawU(ug);
        this.title.drawU(ug.apply(new UTranslate((total.getWidth() - text.getWidth()) / 2.0, 5.0)));
        this.attribute.drawU(ug.apply(new UTranslate(5.0, 5.0 + text.getHeight() + 5.0)));
        double spaceYforURL = this.getSpaceYforURL(ug.getStringBounder());
        this.im.drawU(ug.apply(new UTranslate(5.0, spaceYforURL)));
        if (this.withSymbol) {
            EntityImageState.drawSymbol(ug.apply(this.borderColor), total.getWidth(), total.getHeight());
        }
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private double getSpaceYforURL(StringBounder stringBounder) {
        XDimension2D text = this.title.calculateDimension(stringBounder);
        XDimension2D attr = this.attribute.calculateDimension(stringBounder);
        double marginForFields = attr.getHeight() > 0.0 ? 5.0 : 0.0;
        double titreHeight = 5.0 + text.getHeight() + 5.0;
        double suppY = titreHeight + marginForFields + attr.getHeight();
        return suppY + 5.0;
    }

    @Override
    public HColor getBackcolor() {
        return null;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D img = this.im.calculateDimension(stringBounder);
        XDimension2D text = this.title.calculateDimension(stringBounder);
        XDimension2D attr = this.attribute.calculateDimension(stringBounder);
        XDimension2D dim = text.mergeTB(attr, img);
        double marginForFields = attr.getHeight() > 0.0 ? 5.0 : 0.0;
        XDimension2D result = dim.delta(20.0 + marginForFields);
        return result;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public boolean isHidden() {
        return this.im.isHidden();
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }
}

