/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.ant.compress.taskdefs;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import znaishaded.org.apache.ant.compress.util.CompressorStreamFactory;
import znaishaded.org.apache.ant.compress.util.CompressorWithConcatenatedStreamsFactory;
import znaishaded.org.apache.ant.compress.util.StreamHelper;
import znaishaded.org.apache.commons.compress.compressors.CompressorInputStream;
import znaishaded.org.apache.commons.compress.utils.IOUtils;
import znaishaded.org.apache.tools.ant.BuildException;
import znaishaded.org.apache.tools.ant.taskdefs.Unpack;
import znaishaded.org.apache.tools.ant.util.FileUtils;

public abstract class UnpackBase
extends Unpack {
    private static final int BUFFER_SIZE = 8192;
    private final String defaultExtension;
    private CompressorStreamFactory factory;
    private boolean decompressConcatenated = false;

    protected UnpackBase(String defaultExtension, CompressorStreamFactory factory) {
        this(defaultExtension);
        this.setFactory(factory);
    }

    protected UnpackBase(String defaultExtension) {
        this.defaultExtension = defaultExtension;
    }

    protected final void setFactory(CompressorStreamFactory factory) {
        this.factory = factory;
    }

    @Override
    protected final String getDefaultExtension() {
        return this.defaultExtension;
    }

    public void setDecompressConcatenated(boolean b) {
        if (b && !(this.factory instanceof CompressorWithConcatenatedStreamsFactory)) {
            throw new BuildException("concatenated streams are not supportedby this compression format.");
        }
        this.decompressConcatenated = b;
    }

    @Override
    protected void extract() {
        if (this.source.lastModified() > this.dest.lastModified()) {
            this.log("Expanding " + this.source.getAbsolutePath() + " to " + this.dest.getAbsolutePath());
            CompressorInputStream zIn = null;
            InputStream fis = null;
            try (OutputStream out = Files.newOutputStream(this.dest.toPath(), new OpenOption[0]);){
                zIn = StreamHelper.getInputStream(this.factory, this.srcResource);
                if (zIn == null) {
                    fis = this.srcResource.getInputStream();
                    if (this.factory instanceof CompressorWithConcatenatedStreamsFactory) {
                        CompressorWithConcatenatedStreamsFactory f = (CompressorWithConcatenatedStreamsFactory)this.factory;
                        zIn = f.getCompressorStream(new BufferedInputStream(fis), this.decompressConcatenated);
                    } else {
                        zIn = this.factory.getCompressorStream(new BufferedInputStream(fis));
                    }
                }
                IOUtils.copy(zIn, out, 8192);
            }
            catch (IOException ioe) {
                try {
                    String msg = "Problem expanding " + ioe.getMessage();
                    throw new BuildException(msg, ioe, this.getLocation());
                }
                catch (Throwable throwable) {
                    FileUtils.close(fis);
                    FileUtils.close(zIn);
                    throw throwable;
                }
            }
            FileUtils.close(fis);
            FileUtils.close(zIn);
        }
    }

    @Override
    protected final boolean supportsNonFileResources() {
        return true;
    }
}

