/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.IOException;
import java.util.Deque;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import znaishaded.org.apache.commons.compress.archivers.zip.ScatterStatistics;
import znaishaded.org.apache.commons.compress.archivers.zip.ScatterZipOutputStream;
import znaishaded.org.apache.commons.compress.archivers.zip.StreamCompressor;
import znaishaded.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import znaishaded.org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequest;
import znaishaded.org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequestSupplier;
import znaishaded.org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import znaishaded.org.apache.commons.compress.parallel.FileBasedScatterGatherBackingStore;
import znaishaded.org.apache.commons.compress.parallel.InputStreamSupplier;
import znaishaded.org.apache.commons.compress.parallel.ScatterGatherBackingStore;
import znaishaded.org.apache.commons.compress.parallel.ScatterGatherBackingStoreSupplier;

public class ParallelScatterZipCreator {
    private final Deque<ScatterZipOutputStream> streams = new ConcurrentLinkedDeque<ScatterZipOutputStream>();
    private final ExecutorService es;
    private final ScatterGatherBackingStoreSupplier backingStoreSupplier;
    private final Deque<Future<? extends ScatterZipOutputStream>> futures = new ConcurrentLinkedDeque<Future<? extends ScatterZipOutputStream>>();
    private final long startedAt = System.currentTimeMillis();
    private long compressionDoneAt;
    private long scatterDoneAt;
    private final int compressionLevel;
    private final ThreadLocal<ScatterZipOutputStream> tlScatterStreams = new ThreadLocal<ScatterZipOutputStream>(){

        @Override
        protected ScatterZipOutputStream initialValue() {
            try {
                ScatterZipOutputStream scatterStream = ParallelScatterZipCreator.this.createDeferred(ParallelScatterZipCreator.this.backingStoreSupplier);
                ParallelScatterZipCreator.this.streams.add(scatterStream);
                return scatterStream;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };

    private ScatterZipOutputStream createDeferred(ScatterGatherBackingStoreSupplier scatterGatherBackingStoreSupplier) throws IOException {
        ScatterGatherBackingStore bs = scatterGatherBackingStoreSupplier.get();
        StreamCompressor sc = StreamCompressor.create(this.compressionLevel, bs);
        return new ScatterZipOutputStream(bs, sc);
    }

    public ParallelScatterZipCreator() {
        this(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
    }

    public ParallelScatterZipCreator(ExecutorService executorService) {
        this(executorService, new DefaultBackingStoreSupplier());
    }

    public ParallelScatterZipCreator(ExecutorService executorService, ScatterGatherBackingStoreSupplier backingStoreSupplier) {
        this(executorService, backingStoreSupplier, -1);
    }

    public ParallelScatterZipCreator(ExecutorService executorService, ScatterGatherBackingStoreSupplier backingStoreSupplier, int compressionLevel) throws IllegalArgumentException {
        if ((compressionLevel < 0 || compressionLevel > 9) && compressionLevel != -1) {
            throw new IllegalArgumentException("Compression level is expected between -1~9");
        }
        this.backingStoreSupplier = backingStoreSupplier;
        this.es = executorService;
        this.compressionLevel = compressionLevel;
    }

    public void addArchiveEntry(ZipArchiveEntry zipArchiveEntry, InputStreamSupplier source) {
        this.submitStreamAwareCallable(this.createCallable(zipArchiveEntry, source));
    }

    public void addArchiveEntry(ZipArchiveEntryRequestSupplier zipArchiveEntryRequestSupplier) {
        this.submitStreamAwareCallable(this.createCallable(zipArchiveEntryRequestSupplier));
    }

    public final void submit(Callable<? extends Object> callable) {
        this.submitStreamAwareCallable(() -> {
            callable.call();
            return this.tlScatterStreams.get();
        });
    }

    public final void submitStreamAwareCallable(Callable<? extends ScatterZipOutputStream> callable) {
        this.futures.add(this.es.submit(callable));
    }

    public final Callable<ScatterZipOutputStream> createCallable(ZipArchiveEntry zipArchiveEntry, InputStreamSupplier source) {
        int method = zipArchiveEntry.getMethod();
        if (method == -1) {
            throw new IllegalArgumentException("Method must be set on zipArchiveEntry: " + zipArchiveEntry);
        }
        ZipArchiveEntryRequest zipArchiveEntryRequest = ZipArchiveEntryRequest.createZipArchiveEntryRequest(zipArchiveEntry, source);
        return () -> {
            ScatterZipOutputStream scatterStream = this.tlScatterStreams.get();
            scatterStream.addArchiveEntry(zipArchiveEntryRequest);
            return scatterStream;
        };
    }

    public final Callable<ScatterZipOutputStream> createCallable(ZipArchiveEntryRequestSupplier zipArchiveEntryRequestSupplier) {
        return () -> {
            ScatterZipOutputStream scatterStream = this.tlScatterStreams.get();
            scatterStream.addArchiveEntry(zipArchiveEntryRequestSupplier.get());
            return scatterStream;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(ZipArchiveOutputStream targetStream) throws IOException, InterruptedException, ExecutionException {
        try {
            try {
                for (Future<? extends ScatterZipOutputStream> future : this.futures) {
                    future.get();
                }
            }
            finally {
                this.es.shutdown();
            }
            this.es.awaitTermination(60000L, TimeUnit.SECONDS);
            this.compressionDoneAt = System.currentTimeMillis();
            for (Future<? extends ScatterZipOutputStream> future : this.futures) {
                ScatterZipOutputStream scatterStream = future.get();
                scatterStream.zipEntryWriter().writeNextZipEntry(targetStream);
            }
            for (ScatterZipOutputStream scatterStream : this.streams) {
                scatterStream.close();
            }
            this.scatterDoneAt = System.currentTimeMillis();
        }
        finally {
            this.closeAll();
        }
    }

    public ScatterStatistics getStatisticsMessage() {
        return new ScatterStatistics(this.compressionDoneAt - this.startedAt, this.scatterDoneAt - this.compressionDoneAt);
    }

    private void closeAll() {
        for (ScatterZipOutputStream scatterStream : this.streams) {
            try {
                scatterStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static class DefaultBackingStoreSupplier
    implements ScatterGatherBackingStoreSupplier {
        final AtomicInteger storeNum = new AtomicInteger(0);

        private DefaultBackingStoreSupplier() {
        }

        @Override
        public ScatterGatherBackingStore get() throws IOException {
            File tempFile = File.createTempFile("parallelscatter", "n" + this.storeNum.incrementAndGet());
            return new FileBasedScatterGatherBackingStore(tempFile);
        }
    }
}

