/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.python.PythonContext;
import org.testingisdocumenting.znai.python.PythonParsedEntry;
import org.testingisdocumenting.znai.python.PythonProperty;
import org.testingisdocumenting.znai.python.PythonType;
import org.testingisdocumenting.znai.python.PythonUtils;
import org.testingisdocumenting.znai.python.pydoc.ParsedPythonDoc;
import org.testingisdocumenting.znai.python.pydoc.PythonDocReturn;
import org.testingisdocumenting.znai.structure.DocStructure;

public class PythonClass {
    private final String name;
    private final PythonContext context;
    private final List<PythonParsedEntry> members;
    private final List<String> baseClasses;

    public PythonClass(String name, PythonContext context) {
        this.name = name;
        this.context = context;
        this.members = new ArrayList<PythonParsedEntry>();
        this.baseClasses = new ArrayList<String>();
        context.registerType(this.name);
    }

    public void addMembers(List<PythonParsedEntry> members) {
        this.members.addAll(members);
    }

    public String getName() {
        return this.name;
    }

    public String buildFullName() {
        return this.context.getDefaultPackageName() + "." + this.name;
    }

    public String getPackageName() {
        return this.context.getDefaultPackageName();
    }

    public String getFileName() {
        return this.context.getFileName();
    }

    public void addBaseClasses(List<String> bases) {
        bases.stream().map(className -> className.contains(".") ? className : this.context.getDefaultPackageName() + "." + className).forEach(this.baseClasses::add);
    }

    public List<String> getBaseClasses() {
        return this.baseClasses;
    }

    public boolean hasProperties() {
        return this.members.stream().anyMatch(PythonParsedEntry::isProperty);
    }

    public List<PythonParsedEntry> getFunctions() {
        return this.members.stream().filter(PythonParsedEntry::isFunction).collect(Collectors.toList());
    }

    public ApiParameters createPropertiesAsApiParameters(DocStructure docStructure, MarkupParser parser, Path parentMarkupPath) {
        ApiParameters apiParameters = new ApiParameters(this.context.getDefaultPackageName() + "_" + this.name + "_properties");
        List<PythonProperty> properties = this.generateProperties();
        for (PythonProperty property : properties) {
            ParsedPythonDoc parsedPythonDoc = new ParsedPythonDoc(property.getPyDocText());
            MarkupParserResult parsedMarkdown = parser.parse(parentMarkupPath, (property.isReadOnly() ? "**[readonly]** " : "") + parsedPythonDoc.getPyDocDescriptionOnly());
            apiParameters.add(property.getName(), this.propertyType(docStructure, property.getType(), parsedPythonDoc.getFuncReturn()), parsedMarkdown.contentToListOfMaps(), parsedMarkdown.getAllText());
        }
        return apiParameters;
    }

    public List<PythonProperty> generateProperties() {
        List rawProperties = this.members.stream().filter(member -> member.getType().equals("property")).collect(Collectors.toList());
        HashMap<String, PythonParsedEntry> entriesGet = new HashMap<String, PythonParsedEntry>();
        HashMap<String, PythonParsedEntry> entriesSet = new HashMap<String, PythonParsedEntry>();
        for (PythonParsedEntry rawProperty : rawProperties) {
            PythonUtils.PropertyNameAndQualifier propertyNameAndQualifier = PythonUtils.extractPropertyNameAndQualifierFromEntryName(rawProperty.getName());
            String name2 = propertyNameAndQualifier.getName();
            String qualifier = propertyNameAndQualifier.getQualifier();
            if (qualifier.equals("get")) {
                entriesGet.put(name2, rawProperty);
                continue;
            }
            if (qualifier.equals("set")) {
                entriesSet.put(name2, rawProperty);
                continue;
            }
            throw new IllegalArgumentException("unrecognized qualifier <" + qualifier + ">: " + rawProperty.getName());
        }
        return entriesGet.keySet().stream().map(name -> {
            PythonParsedEntry entryGet = (PythonParsedEntry)entriesGet.get(name);
            return new PythonProperty((String)name, entryGet.getReturns(), !entriesSet.containsKey(name), entryGet.getDocString());
        }).collect(Collectors.toList());
    }

    private ApiLinkedText propertyType(DocStructure docStructure, PythonType hintType, PythonDocReturn docReturn) {
        return hintType.isDefined() ? hintType.convertToApiLinkedText(docStructure) : new ApiLinkedText(docReturn.getType());
    }
}

