/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.resources;

import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.resources.UnresolvedResourceException;
import org.testingisdocumenting.znai.utils.ServiceLoaderUtils;

public class ResourcesResolverChain
implements ResourcesResolver {
    private final Map<String, Path> outsideDocRequestedResources = new HashMap<String, Path>();
    private final List<ResourcesResolver> resolvers = new ArrayList<ResourcesResolver>(ServiceLoaderUtils.load(ResourcesResolver.class));

    public void addResolver(ResourcesResolver resourcesResolver) {
        this.resolvers.add(resourcesResolver);
    }

    @Override
    public void initialize(Stream<String> filteredLookupPaths) {
        List<String> lookupPaths = filteredLookupPaths.toList();
        this.resolvers.forEach(r -> this.initializeWithFilteredPaths((ResourcesResolver)r, lookupPaths.stream()));
    }

    @Override
    public boolean supportsLookupPath(String lookupPath) {
        return true;
    }

    @Override
    public boolean canResolve(String path) {
        return this.resolvers.stream().map(r -> r.canResolve(path)).filter(can -> can).findFirst().orElse(false);
    }

    @Override
    public List<String> listOfTriedLocations(String path) {
        return this.resolvers.stream().flatMap(r -> r.listOfTriedLocations(path).stream()).collect(Collectors.toList());
    }

    @Override
    public String textContent(String path) {
        return this.resolver(path).textContent(path);
    }

    @Override
    public BufferedImage imageContent(String path) {
        return this.resolver(path).imageContent(path);
    }

    @Override
    public Path fullPath(String path) {
        Path result = this.resolver(path).fullPath(path);
        if (!this.isInsideDoc(result)) {
            this.outsideDocRequestedResources.put(path, result);
        }
        return result;
    }

    @Override
    public Path docRootRelativePath(Path path) {
        return this.resolver(path.toString()).docRootRelativePath(path);
    }

    @Override
    public boolean isInsideDoc(Path path) {
        return this.resolver(path.toString()).isInsideDoc(path);
    }

    @Override
    public boolean isLocalFile(String path) {
        return this.resolver(path).isLocalFile(path);
    }

    public Map<String, Path> getOutsideDocRequestedResources() {
        return this.outsideDocRequestedResources;
    }

    private void initializeWithFilteredPaths(ResourcesResolver r, Stream<String> filteredLookupPaths) {
        r.initialize(filteredLookupPaths.filter(r::supportsLookupPath).toList().stream());
    }

    private ResourcesResolver resolver(String path) {
        return this.resolvers.stream().filter(r -> r.canResolve(path)).findFirst().orElseThrow(() -> new UnresolvedResourceException(this.resolvers.stream(), path));
    }
}

