/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.text;

import java.util.List;
import org.testingisdocumenting.znai.text.TextLinesAccessor;

public class MultilineIndexFinder {
    public static StartEndIdx findIdxForMultiLinesShortestDistanceBetween(TextLinesAccessor text, List<String> matchLines) {
        int minDistanceIdx = -1;
        int minDistance = Integer.MAX_VALUE;
        for (int idx = 0; idx < text.numberOfLines() - matchLines.size(); ++idx) {
            int distance = MultilineIndexFinder.matchLinesContaining(text, idx, matchLines);
            if (distance == -1 || distance >= minDistance) continue;
            minDistanceIdx = idx;
            minDistance = distance;
        }
        return new StartEndIdx(minDistanceIdx, minDistanceIdx + minDistance - 1);
    }

    static int matchLinesContaining(TextLinesAccessor text, int startIdx, List<String> matchLines) {
        int idx = startIdx;
        int len = text.numberOfLines();
        int matchLen = matchLines.size();
        if (len == 0 || matchLen == 0) {
            return -1;
        }
        if (idx + matchLen > len) {
            return -1;
        }
        if (!text.lineAtIdx(idx).contains(matchLines.get(0))) {
            return -1;
        }
        int numberOfMatched = 1;
        ++idx;
        int matchIdx = 1;
        while (matchIdx < matchLen && idx < len - matchLen) {
            String matchLine = matchLines.get(matchIdx);
            String line = text.lineAtIdx(idx);
            if (line.contains(matchLine)) {
                ++matchIdx;
                ++numberOfMatched;
            }
            ++idx;
        }
        return numberOfMatched == matchLen ? idx - startIdx : -1;
    }

    public record StartEndIdx(int startIdx, int endIdx) {
        int distance() {
            return this.endIdx - this.startIdx + 1;
        }
    }
}

