/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonpatch;

import java.io.IOException;
import znaishaded.com.fasterxml.jackson.annotation.JsonCreator;
import znaishaded.com.fasterxml.jackson.annotation.JsonProperty;
import znaishaded.com.fasterxml.jackson.core.JsonGenerator;
import znaishaded.com.fasterxml.jackson.core.JsonProcessingException;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.SerializerProvider;
import znaishaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import znaishaded.com.fasterxml.jackson.databind.node.ArrayNode;
import znaishaded.com.fasterxml.jackson.databind.node.MissingNode;
import znaishaded.com.fasterxml.jackson.databind.node.ObjectNode;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.com.github.fge.jsonpatch.Iterables;
import znaishaded.com.github.fge.jsonpatch.JsonPatchException;
import znaishaded.com.github.fge.jsonpatch.JsonPatchOperation;

public final class RemoveOperation
extends JsonPatchOperation {
    @JsonCreator
    public RemoveOperation(@JsonProperty(value="path") JsonPointer path) {
        super("remove", path);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        if (this.path.isEmpty()) {
            return MissingNode.getInstance();
        }
        if (this.path.path(node).isMissingNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchPath"));
        }
        Object ret = node.deepCopy();
        JsonNode parentNode = (JsonNode)this.path.parent().get(ret);
        String raw = Iterables.getLast(this.path).getToken().getRaw();
        if (parentNode.isObject()) {
            ((ObjectNode)parentNode).remove(raw);
        } else {
            ((ArrayNode)parentNode).remove(Integer.parseInt(raw));
        }
        return ret;
    }

    @Override
    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        jgen.writeStringField("op", "remove");
        jgen.writeStringField("path", this.path.toString());
        jgen.writeEndObject();
    }

    @Override
    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        this.serialize(jgen, provider);
    }

    @Override
    public String toString() {
        return "op: " + this.op + "; path: \"" + this.path + '\"';
    }
}

