/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.JsonLoader;

public enum SchemaVersion {
    DRAFTV4("http://json-schema.org/draft-04/schema#", "/draftv4/schema"),
    DRAFTV3("http://json-schema.org/draft-03/schema#", "/draftv3/schema"),
    DRAFTV4_HYPERSCHEMA("http://json-schema.org/draft-04/hyper-schema#", "/draftv4/hyper-schema");

    private final URI location;
    private final JsonNode schema;

    private SchemaVersion(String uri, String resource) {
        try {
            this.location = URI.create(uri);
            URL url = SchemaVersion.class.getResource(resource);
            this.schema = JsonLoader.fromURL(url);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public URI getLocation() {
        return this.location;
    }

    public JsonNode getSchema() {
        return this.schema.deepCopy();
    }
}

