/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.parser;

import java.net.URI;
import java.net.URISyntaxException;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.io.swagger.deserializer.ApiDeclarationDeserializer;
import znaishaded.io.swagger.deserializer.ResourceListingDeserializer;
import znaishaded.io.swagger.io.Authentication;
import znaishaded.io.swagger.io.NoAuthentication;
import znaishaded.io.swagger.models.apideclaration.ApiDeclaration;
import znaishaded.io.swagger.models.resourcelisting.ResourceListing;
import znaishaded.io.swagger.parser.SwaggerException;
import znaishaded.io.swagger.reader.SwaggerReader;
import znaishaded.io.swagger.reader.SwaggerReaderConfiguration;
import znaishaded.io.swagger.reader.SwaggerReaderFactory;
import znaishaded.io.swagger.report.Message;
import znaishaded.io.swagger.report.MessageBuilder;
import znaishaded.io.swagger.report.Severity;
import znaishaded.io.swagger.transform.migrate.ApiDeclarationMigrator;
import znaishaded.io.swagger.transform.migrate.ResourceListingMigrator;
import znaishaded.io.swagger.validate.ApiDeclarationJsonValidator;
import znaishaded.io.swagger.validate.ResourceListingJsonValidator;

public class SwaggerLegacyParser {
    public ResourceListing read(String url) {
        return this.read(url, new NoAuthentication());
    }

    public ResourceListing read(String url, Authentication authentication) {
        MessageBuilder messageBuilder = new MessageBuilder();
        SwaggerReader swaggerReader = new SwaggerReaderFactory(new SwaggerReaderConfiguration()).newReader();
        JsonNode jsonNode = swaggerReader.read(url, authentication, messageBuilder);
        this.validateMessageReport(messageBuilder);
        ResourceListingMigrator resourceListingMigrator = new ResourceListingMigrator();
        jsonNode = resourceListingMigrator.migrate(messageBuilder, jsonNode);
        this.validateMessageReport(messageBuilder);
        ResourceListingJsonValidator resourceListingJsonValidator = new ResourceListingJsonValidator();
        resourceListingJsonValidator.validate(messageBuilder, jsonNode);
        this.validateMessageReport(messageBuilder);
        ResourceListingDeserializer resourceListingDeserializer = new ResourceListingDeserializer();
        ResourceListing resourceListing = (ResourceListing)resourceListingDeserializer.deserialize(jsonNode, messageBuilder);
        this.validateMessageReport(messageBuilder);
        return resourceListing;
    }

    public ApiDeclaration read(String url, String resourcePath) {
        return this.read(url, resourcePath, new NoAuthentication());
    }

    public ApiDeclaration read(String url, String resourcePath, Authentication authentication) {
        MessageBuilder messageBuilder = new MessageBuilder();
        SwaggerReader swaggerReader = new SwaggerReaderFactory(new SwaggerReaderConfiguration()).newReader();
        JsonNode jsonNode = null;
        try {
            String resourceListingURL = this.getResourceListingURL(url, resourcePath);
            jsonNode = swaggerReader.read(resourceListingURL, authentication, messageBuilder);
        }
        catch (URISyntaxException e) {
            messageBuilder.append(new Message("", e.getMessage(), Severity.ERROR));
        }
        this.validateMessageReport(messageBuilder);
        ApiDeclarationMigrator apiDeclarationMigrator = new ApiDeclarationMigrator();
        jsonNode = apiDeclarationMigrator.migrate(messageBuilder, jsonNode);
        this.validateMessageReport(messageBuilder);
        ApiDeclarationJsonValidator apiDeclarationJsonValidator = new ApiDeclarationJsonValidator();
        apiDeclarationJsonValidator.validate(messageBuilder, jsonNode);
        this.validateMessageReport(messageBuilder);
        ApiDeclarationDeserializer apiDeclarationDeserializer = new ApiDeclarationDeserializer();
        ApiDeclaration apiDeclaration = (ApiDeclaration)apiDeclarationDeserializer.deserialize(jsonNode, messageBuilder);
        this.validateMessageReport(messageBuilder);
        return apiDeclaration;
    }

    private String getResourceListingURL(String url, String resourcePath) throws URISyntaxException {
        URI uri = new URI(resourcePath);
        String resourceListingUrl = uri.isAbsolute() ? resourcePath : url + resourcePath;
        return resourceListingUrl;
    }

    private void validateMessageReport(MessageBuilder messageBuilder) {
        System.out.println((Object)messageBuilder.getHighestSeverity());
        if (messageBuilder.getHighestSeverity() == Severity.ERROR) {
            throw new SwaggerException(messageBuilder.toString());
        }
    }
}

