/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.auth;

import java.util.HashMap;
import java.util.Map;
import znaishaded.io.vertx.ext.auth.HashingAlgorithm;

public final class HashString {
    private String id;
    private Map<String, String> params;
    private String salt;
    private String hash;

    public HashString(String id, Map<String, String> params, String salt) {
        this.id = id;
        this.params = params;
        this.salt = salt;
    }

    public HashString(String encoded) {
        String[] parts;
        if (encoded.length() > 1 && encoded.charAt(0) != '$') {
            encoded = encoded.replaceAll("\\{", "\\$\\{");
            if ((encoded = encoded.replaceAll("\\}", "\\}\\$")).length() > 1 && encoded.charAt(0) != '$') {
                encoded = "$$" + encoded;
            }
        }
        if ((parts = encoded.split("\\$")).length < 2) {
            throw new IllegalStateException("Not enough segments: " + encoded);
        }
        switch (parts.length) {
            case 2: {
                this.id = parts[1];
            }
            case 3: {
                this.id = parts[1];
                this.hash = parts[2];
                break;
            }
            case 4: {
                this.id = parts[1];
                this.salt = parts[2];
                this.hash = parts[3];
                break;
            }
            default: {
                this.id = parts[1];
                this.params = new HashMap<String, String>();
                for (String kv : parts[2].split(",")) {
                    int eq = kv.indexOf(61);
                    if (eq <= 0) continue;
                    this.params.put(kv.substring(0, eq), kv.substring(eq + 1));
                }
                this.salt = parts[3];
                this.hash = parts[4];
            }
        }
    }

    public String id() {
        return this.id;
    }

    public String param(String param) {
        if (this.params == null) {
            return null;
        }
        return this.params.get(param);
    }

    public Map<String, String> params() {
        return this.params;
    }

    public String salt() {
        return this.salt;
    }

    public String hash() {
        return this.hash;
    }

    public static String encode(HashingAlgorithm algorithm, Map<String, String> params, String salt, String hash) {
        StringBuilder sb = new StringBuilder();
        if (algorithm.needsSeparator()) {
            sb.append('$');
        }
        sb.append(algorithm.id());
        if (params != null) {
            if (algorithm.needsSeparator()) {
                sb.append('$');
            }
            boolean notEmpty = false;
            for (String key : algorithm.params()) {
                String value = params.get(key);
                if (value == null) continue;
                if (notEmpty) {
                    sb.append(',');
                }
                sb.append(key);
                sb.append('=');
                sb.append(params.get(key));
                notEmpty = true;
            }
        }
        if (salt != null) {
            if (algorithm.needsSeparator()) {
                sb.append('$');
            }
            sb.append(salt);
        }
        if (hash != null) {
            if (algorithm.needsSeparator()) {
                sb.append('$');
            }
            sb.append(hash);
        }
        return sb.toString();
    }

    public String toString() {
        return "id=" + this.id() + ",params=" + this.params() + ",salt=" + this.salt() + ",hash=" + this.hash();
    }
}

