/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.descdiagram.command;

import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.LeafType;
import znaishaded.net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.Trim;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbols;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.Colors;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontParam;
import znaishaded.net.sourceforge.plantuml.plasma.Quark;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.url.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.utils.BlocLines;

public class CommandArchimateMultilines
extends CommandMultilines2<AbstractEntityDiagram> {
    public CommandArchimateMultilines() {
        super(CommandArchimateMultilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
    }

    @Override
    public String getPatternEnd() {
        return "^(.*)\\]$";
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandArchimateMultilines.class.getName(), RegexLeaf.start(), new RegexLeaf("archimate"), RegexLeaf.spaceOneOrMore(), CommandArchimateMultilines.color().getRegex(), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE", "(?:\\<\\<([-\\w]+)\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\["), new RegexLeaf("DESC", "(.*)"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeNow(AbstractEntityDiagram diagram, BlocLines lines) throws NoSuchColorException {
        lines = lines.trim();
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        String codeRaw = line0.getLazzy("CODE", 0);
        Quark<Entity> quark = diagram.quarkInContext(false, diagram.cleanId(codeRaw));
        if (quark.getData() != null) {
            return CommandExecutionResult.error("Already exists " + quark.getName());
        }
        String icon = line0.getLazzy("STEREOTYPE", 0);
        Entity entity = diagram.reallyCreateLeaf(quark, Display.getWithNewlines(quark), LeafType.DESCRIPTION, USymbols.RECTANGLE);
        lines = lines.subExtract(1, 1);
        Display display = lines.toDisplay();
        entity.setDisplay(display);
        entity.setUSymbol(USymbols.RECTANGLE);
        if (icon != null) {
            entity.setStereotype(Stereotype.build("<<$archimate/" + icon + ">>", diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        Colors colors = CommandArchimateMultilines.color().getColor(line0, diagram.getSkinParam().getIHtmlColorSet());
        entity.setColors(colors);
        return CommandExecutionResult.ok();
    }
}

