/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.flowdiagram;

import znaishaded.net.sourceforge.plantuml.golem.Tile;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;

public class ActivityBox
extends AbstractTextBlock {
    private static final int CORNER = 25;
    private static final int MARGIN = 10;
    private final Tile tile;
    private final String id;
    private final String label;
    private final TextBlock tb;

    public ActivityBox(Tile tile, String id, String label) {
        this.tile = tile;
        this.id = id;
        this.label = label;
        UFont font = UFont.serif(14);
        FontConfiguration fc = FontConfiguration.blackBlueTrue(font);
        this.tb = Display.create(label).create(fc, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    public Tile getTile() {
        return this.tile;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public void drawU(UGraphic ug) {
        XDimension2D dimTotal = this.calculateDimension(ug.getStringBounder());
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = URectangle.build(widthTotal, heightTotal).rounded(25.0);
        ug = ug.apply(HColors.MY_RED);
        ug = ug.apply(HColors.MY_YELLOW.bg());
        ug.apply(UStroke.withThickness(1.5)).draw(rect);
        this.tb.drawU(ug.apply(new UTranslate(10.0, 10.0)));
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim = this.tb.calculateDimension(stringBounder);
        return dim.delta(20.0, 20.0);
    }
}

