/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.gitlog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.gitlog.Commit;
import znaishaded.net.sourceforge.plantuml.gitlog.GNode;

public class GNodeBuilder {
    private final List<GNode> all = new ArrayList<GNode>();

    public GNodeBuilder(List<Commit> allCommits) {
        LinkedHashMap<String, GNode> tmp = new LinkedHashMap<String, GNode>();
        for (Commit commit : allCommits) {
            GNode node = new GNode();
            node.setComment(commit.getComment());
            node.addText(commit.getName());
            tmp.put(commit.getName(), node);
        }
        for (Commit commit : allCommits) {
            for (Commit parent : commit.getAncestors()) {
                GNode.link((GNode)tmp.get(commit.getName()), (GNode)tmp.get(parent.getName()));
            }
        }
        this.all.addAll(tmp.values());
        this.merge();
    }

    private void merge() {
        boolean changed;
        block0: do {
            changed = false;
            for (GNode node : this.all) {
                if (!node.canEatTheNextOne()) continue;
                GNode removed = node.eatTheNextOne();
                this.all.remove(removed);
                changed = true;
                continue block0;
            }
        } while (changed);
    }

    public Collection<GNode> getAllNodes() {
        return Collections.unmodifiableCollection(this.all);
    }
}

