/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole.command;

import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColorSet;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorRuntimeException;
import znaishaded.net.sourceforge.plantuml.klimt.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.regex.Pattern2;

public class CommandCreoleColorAndSizeChange
implements Command {
    private final Pattern2 mypattern;
    public static final String fontPattern = "\\<font(?:[%s]+size[%s]*=[%s]*[%g]?(\\d+)[%g]?|[%s]+color[%s]*=[%s]*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>";
    private static final Pattern2 pattern = MyPattern.cmpile("^(\\<font(?:[%s]+size[%s]*=[%s]*[%g]?(\\d+)[%g]?|[%s]+color[%s]*=[%s]*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>(.*?)\\</font\\>)");
    private static final Pattern2 patternEol = MyPattern.cmpile("^(\\<font(?:[%s]+size[%s]*=[%s]*[%g]?(\\d+)[%g]?|[%s]+color[%s]*=[%s]*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>(.*))$");

    @Override
    public String startingChars() {
        return "<";
    }

    public static Command create() {
        return new CommandCreoleColorAndSizeChange(pattern);
    }

    public static Command createEol() {
        return new CommandCreoleColorAndSizeChange(patternEol);
    }

    private CommandCreoleColorAndSizeChange(Pattern2 pattern) {
        this.mypattern = pattern;
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m3 = this.mypattern.matcher(line);
        if (!m3.find()) {
            return 0;
        }
        return m3.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) throws NoSuchColorRuntimeException {
        FontConfiguration fc1;
        Matcher2 m3 = this.mypattern.matcher(line);
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc2 = fc1 = stripe.getActualFontConfiguration();
        if (m3.group(2) != null) {
            fc2 = fc2.changeSize(Integer.parseInt(m3.group(2)));
        }
        try {
            if (m3.group(3) != null) {
                String s2 = m3.group(3);
                HColor color = HColorSet.instance().getColor(s2);
                fc2 = fc2.changeColor(color);
            }
            stripe.setActualFontConfiguration(fc2);
            stripe.analyzeAndAdd(m3.group(4));
            stripe.setActualFontConfiguration(fc1);
            return line.substring(m3.group(1).length());
        }
        catch (NoSuchColorException e) {
            throw new NoSuchColorRuntimeException();
        }
    }
}

