/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.drawing.hand;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import znaishaded.net.sourceforge.plantuml.klimt.UPath;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XCubicCurve2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UPolygon;

public class HandJiggle {
    private final Collection<XPoint2D> points = new ArrayList<XPoint2D>();
    private double startX;
    private double startY;
    private final double defaultVariation;
    private final Random rnd;

    private double randomMe() {
        return this.rnd.nextDouble();
    }

    public HandJiggle(double startX, double startY, double defaultVariation, Random rnd) {
        this.startX = startX;
        this.startY = startY;
        this.defaultVariation = defaultVariation;
        this.rnd = rnd;
        this.points.add(new XPoint2D(startX, startY));
    }

    public static HandJiggle create(XPoint2D start, double defaultVariation, Random rnd) {
        return new HandJiggle(start.getX(), start.getY(), defaultVariation, rnd);
    }

    public void lineTo(XPoint2D end) {
        this.lineTo(end.getX(), end.getY());
    }

    public void arcTo(double angle0, double angle1, double centerX, double centerY, double rx, double ry) {
        this.lineTo(HandJiggle.pointOnCircle(centerX, centerY, (angle0 + angle1) / 2.0, rx, ry));
        this.lineTo(HandJiggle.pointOnCircle(centerX, centerY, angle1, rx, ry));
    }

    private static XPoint2D pointOnCircle(double centerX, double centerY, double angle, double rx, double ry) {
        double x = centerX + Math.cos(angle) * rx;
        double y = centerY + Math.sin(angle) * ry;
        return new XPoint2D(x, y);
    }

    public void lineTo(double endX, double endY) {
        double diffY;
        double diffX = Math.abs(endX - this.startX);
        double distance = Math.sqrt(diffX * diffX + (diffY = Math.abs(endY - this.startY)) * diffY);
        if (distance < 0.001) {
            return;
        }
        int segments = (int)Math.round(distance / 10.0);
        double variation = this.defaultVariation;
        if (segments < 5) {
            segments = 5;
            variation /= 3.0;
        }
        double stepX = Math.signum(endX - this.startX) * diffX / (double)segments;
        double stepY = Math.signum(endY - this.startY) * diffY / (double)segments;
        double fx = diffX / distance;
        double fy = diffY / distance;
        for (int s2 = 0; s2 < segments; ++s2) {
            double x = stepX * (double)s2 + this.startX;
            double y = stepY * (double)s2 + this.startY;
            double offset = (this.randomMe() - 0.5) * variation;
            this.points.add(new XPoint2D(x - offset * fy, y - offset * fx));
        }
        this.points.add(new XPoint2D(endX, endY));
        this.startX = endX;
        this.startY = endY;
    }

    public void curveTo(XCubicCurve2D curve) {
        double flatness = curve.getFlatness();
        double dist = curve.getP1().distance(curve.getP2());
        if (flatness > 0.1 && dist > 20.0) {
            XCubicCurve2D left = XCubicCurve2D.none();
            XCubicCurve2D right = XCubicCurve2D.none();
            curve.subdivide(left, right);
            this.curveTo(left);
            this.curveTo(right);
            return;
        }
        this.lineTo(curve.getP2());
    }

    public UPolygon toUPolygon() {
        UPolygon result = new UPolygon();
        for (XPoint2D p : this.points) {
            result.addPoint(p.getX(), p.getY());
        }
        return result;
    }

    public UPath toUPath() {
        UPath path = null;
        for (XPoint2D p : this.points) {
            if (path == null) {
                path = UPath.none();
                path.moveTo(p);
                continue;
            }
            path.lineTo(p);
        }
        if (path == null) {
            throw new IllegalStateException();
        }
        return path;
    }

    public void appendTo(UPath result) {
        for (XPoint2D p : this.points) {
            result.lineTo(p);
        }
    }
}

