/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.plasma;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.plasma.PEntry;
import znaishaded.net.sourceforge.plantuml.plasma.Quark;

public class Plasma<DATA> {
    private String separator = "\u0000";
    private final Quark<DATA> root;
    private final List<Quark<DATA>> quarks = new ArrayList<Quark<DATA>>();
    private final Map<String, PEntry<DATA>> stats = new HashMap<String, PEntry<DATA>>();

    public Plasma() {
        this.root = new Quark(this, null, "");
    }

    protected void register(Quark<DATA> quark) {
        this.quarks.add(quark);
        PEntry<DATA> ent = this.stats.get(quark.getName());
        if (ent == null) {
            ent = new PEntry<DATA>(quark);
            this.stats.put(quark.getName(), ent);
        } else {
            ++ent.counter;
        }
    }

    public Quark<DATA> root() {
        return this.root;
    }

    public final String getSeparator() {
        return this.separator;
    }

    public final void setSeparator(String separator) {
        if (separator == null) {
            separator = "\u0000";
        }
        this.separator = separator;
    }

    public final boolean hasSeparator() {
        return !this.separator.equals("\u0000");
    }

    public Collection<Quark<DATA>> quarks() {
        return Collections.unmodifiableCollection(this.quarks);
    }

    public Quark<DATA> firstWithName(String name) {
        PEntry<DATA> ent = this.stats.get(name);
        if (ent == null) {
            return null;
        }
        return ent.first;
    }

    public int countByName(String name) {
        PEntry<DATA> ent = this.stats.get(name);
        if (ent == null) {
            return 0;
        }
        return ent.counter;
    }
}

