/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.draw;

import znaishaded.net.sourceforge.plantuml.klimt.UShape;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UPolygon;
import znaishaded.net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.project.LabelStrategy;
import znaishaded.net.sourceforge.plantuml.project.ToTaskDraw;
import znaishaded.net.sourceforge.plantuml.project.core.Task;
import znaishaded.net.sourceforge.plantuml.project.core.TaskAttribute;
import znaishaded.net.sourceforge.plantuml.project.draw.AbstractTaskDraw;
import znaishaded.net.sourceforge.plantuml.project.draw.FingerPrint;
import znaishaded.net.sourceforge.plantuml.project.lang.CenterBorderColor;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.timescale.TimeScale;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;

public class TaskDrawDiamond
extends AbstractTaskDraw {
    public TaskDrawDiamond(TimeScale timeScale, Real y, String prettyDisplay, Day start, ISkinParam skinParam, Task task, ToTaskDraw toTaskDraw, StyleBuilder styleBuilder) {
        super(timeScale, y, prettyDisplay, start, skinParam, task, toTaskDraw, styleBuilder);
    }

    @Override
    StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.milestone);
    }

    @Override
    public double getHeightMax(StringBounder stringBounder) {
        return this.getFullHeightTask(stringBounder);
    }

    @Override
    protected double getShapeHeight(StringBounder stringBounder) {
        TextBlock title = this.getTitle();
        XDimension2D titleDim = title.calculateDimension(stringBounder);
        return Math.max(titleDim.getHeight(), this.getDiamondHeight());
    }

    private double getDiamondHeight() {
        int result = (int)this.getFontConfiguration().getFont().getSize2D();
        if (result % 2 == 1) {
            --result;
        }
        return result;
    }

    @Override
    public final void drawTitle(UGraphic ug, LabelStrategy labelStrategy, double colTitles, double colBars) {
        double x;
        Style style = this.getStyle();
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        ClockwiseTopRightBottomLeft padding = style.getPadding();
        TextBlock title = this.getTitle();
        ug = ug.apply(UTranslate.dy(margin.getTop()));
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D titleDim = title.calculateDimension(stringBounder);
        double h2 = (this.getShapeHeight(stringBounder) - titleDim.getHeight()) / 2.0;
        if (labelStrategy.titleInFirstColumn()) {
            x = labelStrategy.rightAligned() ? colTitles - titleDim.getWidth() - margin.getRight() : margin.getLeft();
        } else if (labelStrategy.titleInLastColumn()) {
            x = colBars + margin.getLeft();
        } else {
            double x1 = this.timeScale.getStartingPosition(this.start);
            double x2 = this.timeScale.getEndingPosition(this.start);
            double width = this.getDiamondHeight();
            double delta = x2 - x1 - width;
            x = x2 - delta / 2.0 + padding.getLeft();
        }
        title.drawU(ug.apply(new UTranslate(x, h2)));
    }

    @Override
    protected TextBlock getTitle() {
        return Display.getWithNewlines(this.prettyDisplay).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    @Override
    public void drawU(UGraphic ug) {
        Style style = this.getStyle();
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        ug = ug.apply(UTranslate.dy(margin.getTop()));
        double x1 = this.timeScale.getStartingPosition(this.start);
        double x2 = this.timeScale.getEndingPosition(this.start);
        double width = this.getDiamondHeight();
        double delta = x2 - x1 - width;
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        this.drawShape(this.applyColors(ug).apply(UTranslate.dx(x1 + delta / 2.0)));
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private UGraphic applyColors(UGraphic ug) {
        CenterBorderColor col = this.getColors();
        if (col != null && col.isOk()) {
            return col.apply(ug);
        }
        return ug.apply(this.getLineColor()).apply(this.getBackgroundColor().bg());
    }

    private void drawShape(UGraphic ug) {
        ug.draw(this.getDiamond());
    }

    @Override
    public FingerPrint getFingerPrintNote(StringBounder stringBounder) {
        return null;
    }

    @Override
    public FingerPrint getFingerPrint(StringBounder stringBounder) {
        double h2 = this.getFullHeightTask(stringBounder);
        double startPos = this.timeScale.getStartingPosition(this.start);
        return new FingerPrint(startPos, this.getY(stringBounder).getCurrentValue(), startPos + h2, this.getY(stringBounder).getCurrentValue() + h2);
    }

    private UShape getDiamond() {
        double h2 = this.getDiamondHeight();
        UPolygon result = new UPolygon();
        result.addPoint(h2 / 2.0, 0.0);
        result.addPoint(h2, h2 / 2.0);
        result.addPoint(h2 / 2.0, h2);
        result.addPoint(0.0, h2 / 2.0);
        return result;
    }

    @Override
    public double getX1(TaskAttribute taskAttribute) {
        double x1 = this.timeScale.getStartingPosition(this.start);
        double x2 = this.timeScale.getEndingPosition(this.start);
        double width = this.getDiamondHeight();
        double delta = x2 - x1 - width;
        return x1 + delta;
    }

    @Override
    public double getX2(TaskAttribute taskAttribute) {
        double x1 = this.timeScale.getStartingPosition(this.start);
        double x2 = this.timeScale.getEndingPosition(this.start);
        double width = this.getDiamondHeight();
        double delta = x2 - x1 - width;
        return x2 - delta;
    }
}

