/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.timescale;

import znaishaded.net.sourceforge.plantuml.project.core.PrintScale;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.timescale.TimeScale;

public class TimeScaleWink
implements TimeScale {
    private final double scale;
    private final PrintScale printScale;

    public TimeScaleWink(double scale, PrintScale printScale) {
        this.scale = 16.0 * scale;
        this.printScale = printScale;
    }

    @Override
    public double getStartingPosition(Day instant) {
        long wink = instant.getMillis();
        return (double)wink * this.scale / 8.64E7;
    }

    @Override
    public double getEndingPosition(Day instant) {
        return this.getStartingPosition(instant) + this.getWidth(instant);
    }

    @Override
    public double getWidth(Day instant) {
        return this.scale;
    }

    @Override
    public boolean isBreaking(Day instant) {
        if (this.printScale == PrintScale.WEEKLY) {
            long num = instant.getMillis() / 86400000L;
            return num % 7L == 6L;
        }
        return true;
    }
}

