/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.salt.element.AbstractElement;
import znaishaded.net.sourceforge.plantuml.salt.element.Element;
import znaishaded.net.sourceforge.plantuml.salt.element.ElementEmpty;
import znaishaded.net.sourceforge.plantuml.utils.MathUtils;

public class ElementBorder
extends AbstractElement {
    private Element north = new ElementEmpty();
    private Element south = new ElementEmpty();
    private Element east = new ElementEmpty();
    private Element west = new ElementEmpty();
    private Element center = new ElementEmpty();

    public final void setNorth(Element north) {
        this.north = north;
    }

    public final void setSouth(Element south) {
        this.south = south;
    }

    public final void setEast(Element east) {
        this.east = east;
    }

    public final void setWest(Element west) {
        this.west = west;
    }

    public final void setCenter(Element center) {
        this.center = center;
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, XDimension2D dimToUse) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimNorth = this.north.getPreferredDimension(stringBounder, 0.0, 0.0);
        XDimension2D dimSouth = this.south.getPreferredDimension(stringBounder, 0.0, 0.0);
        XDimension2D dimEast = this.east.getPreferredDimension(stringBounder, 0.0, 0.0);
        XDimension2D dimWest = this.west.getPreferredDimension(stringBounder, 0.0, 0.0);
        XPoint2D pA = new XPoint2D(dimWest.getWidth(), dimNorth.getHeight());
        XPoint2D pB = new XPoint2D(dimToUse.getWidth() - dimEast.getWidth(), dimNorth.getHeight());
        XPoint2D pC = new XPoint2D(dimWest.getWidth(), dimToUse.getHeight() - dimSouth.getHeight());
        this.north.drawU(ug, zIndex, dimToUse);
        this.south.drawU(ug.apply(UTranslate.dy(pC.getY())), zIndex, dimToUse);
        this.west.drawU(ug.apply(UTranslate.dy(pA.getY())), zIndex, dimToUse);
        this.east.drawU(ug.apply(new UTranslate(pB.getX(), pB.getY())), zIndex, dimToUse);
        this.center.drawU(ug.apply(new UTranslate(pA.getX(), pA.getY())), zIndex, dimToUse);
    }

    @Override
    public XDimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        XDimension2D dimNorth = this.north.getPreferredDimension(stringBounder, x, y);
        XDimension2D dimSouth = this.south.getPreferredDimension(stringBounder, x, y);
        XDimension2D dimEast = this.east.getPreferredDimension(stringBounder, x, y);
        XDimension2D dimWest = this.west.getPreferredDimension(stringBounder, x, y);
        XDimension2D dimCenter = this.center.getPreferredDimension(stringBounder, x, y);
        double width = MathUtils.max(dimNorth.getWidth(), dimSouth.getWidth(), dimWest.getWidth() + dimCenter.getWidth() + dimEast.getWidth());
        double height = dimNorth.getHeight() + MathUtils.max(dimWest.getHeight(), dimCenter.getHeight(), dimEast.getHeight()) + dimSouth.getHeight();
        return new XDimension2D(width, height);
    }
}

