/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Stairs {
    private final List<Double> ys = new ArrayList<Double>();
    private final List<Integer> values = new ArrayList<Integer>();
    private final Map<Double, Integer> cache = new HashMap<Double, Integer>();

    public String toString() {
        ArrayList<Double> copy = new ArrayList<Double>(this.ys);
        Collections.sort(copy);
        StringBuilder sb = new StringBuilder("[");
        for (Double y : copy) {
            sb.append(y + "=" + this.getValue(y) + " ");
        }
        sb.append("]");
        return sb.toString();
    }

    public void addStep(double y, int value) {
        assert (this.ys.size() == this.values.size());
        if (this.ys.size() > 0) {
            double lastY = this.ys.get(this.ys.size() - 1);
            if (y < lastY) {
                throw new IllegalArgumentException();
            }
            if (lastY == y) {
                this.values.set(this.ys.size() - 1, value);
                this.cache.clear();
                return;
            }
        }
        this.ys.add(y);
        this.values.add(value);
        this.cache.clear();
    }

    public int getMaxValue() {
        int max = Integer.MIN_VALUE;
        for (Integer v : this.values) {
            if (v <= max) continue;
            max = v;
        }
        return max;
    }

    public List<Double> getYs() {
        return Collections.unmodifiableList(this.ys);
    }

    private double getLastY() {
        if (this.ys.size() == 0) {
            return 0.0;
        }
        return this.ys.get(this.ys.size() - 1);
    }

    public int getValue(double y) {
        Integer result = this.cache.get(y);
        if (result == null) {
            result = this.getValueSlow(y);
            this.cache.put(y, result);
        }
        return result;
    }

    private int getValueSlow(double y) {
        int idx = Collections.binarySearch(this.ys, y);
        if (idx >= 0) {
            return this.values.get(idx);
        }
        int insertPoint = -idx - 1;
        if (insertPoint == 0) {
            return 0;
        }
        return this.values.get(insertPoint - 1);
    }

    public int getLastValue() {
        int size = this.values.size();
        if (size == 0) {
            return 0;
        }
        return this.values.get(size - 1);
    }
}

