/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.text;

public enum TLineType {
    PLAIN,
    AFFECTATION_DEFINE,
    AFFECTATION,
    ASSERT,
    IF,
    IFDEF,
    UNDEF,
    IFNDEF,
    ELSE,
    ELSEIF,
    ENDIF,
    WHILE,
    ENDWHILE,
    FOREACH,
    ENDFOREACH,
    DECLARE_RETURN_FUNCTION,
    DECLARE_PROCEDURE,
    END_FUNCTION,
    RETURN,
    LEGACY_DEFINE,
    LEGACY_DEFINELONG,
    THEME,
    INCLUDE,
    INCLUDE_DEF,
    IMPORT,
    STARTSUB,
    ENDSUB,
    INCLUDESUB,
    LOG,
    DUMP_MEMORY,
    COMMENT_SIMPLE,
    COMMENT_LONG_START;


    public static TLineType getFromLineInternal(String s2) {
        if (s2.matches("^\\s*!define\\s+[\\p{L}_][\\p{L}_0-9]*\\(.*")) {
            return LEGACY_DEFINE;
        }
        if (s2.matches("^\\s*!definelong\\s+[\\p{L}_][\\p{L}_0-9]*\\b.*")) {
            return LEGACY_DEFINELONG;
        }
        if (s2.matches("^\\s*!define\\s+[\\p{L}_][\\p{L}_0-9]*\\b.*")) {
            return AFFECTATION_DEFINE;
        }
        if (s2.matches("^\\s*!\\s*(local|global)?\\s*\\$?[\\p{L}_][\\p{L}_0-9]*\\s*\\??=.*")) {
            return AFFECTATION;
        }
        if (s2.matches("^\\s*'.*")) {
            return COMMENT_SIMPLE;
        }
        if (s2.matches("^\\s*/'.*'/\\s*$")) {
            return COMMENT_SIMPLE;
        }
        if (s2.matches("^\\s*/'.*") && !s2.contains("'/")) {
            return COMMENT_LONG_START;
        }
        if (s2.matches("^\\s*!ifdef\\s+.*")) {
            return IFDEF;
        }
        if (s2.matches("^\\s*!undef\\s+.*")) {
            return UNDEF;
        }
        if (s2.matches("^\\s*!ifndef\\s+.*")) {
            return IFNDEF;
        }
        if (s2.matches("^\\s*!assert\\s+.*")) {
            return ASSERT;
        }
        if (s2.matches("^\\s*!if\\s+.*")) {
            return IF;
        }
        if (s2.matches("^\\s*!(unquoted\\s|final\\s)*(function)\\s+\\$?[\\p{L}_][\\p{L}_0-9]*.*")) {
            return DECLARE_RETURN_FUNCTION;
        }
        if (s2.matches("^\\s*!(unquoted\\s|final\\s)*(procedure)\\s+\\$?[\\p{L}_][\\p{L}_0-9]*.*")) {
            return DECLARE_PROCEDURE;
        }
        if (s2.matches("^\\s*!else\\b.*")) {
            return ELSE;
        }
        if (s2.matches("^\\s*!elseif\\b.*")) {
            return ELSEIF;
        }
        if (s2.matches("^\\s*!endif\\b.*")) {
            return ENDIF;
        }
        if (s2.matches("^\\s*!while\\s+.*")) {
            return WHILE;
        }
        if (s2.matches("^\\s*!endwhile\\b.*")) {
            return ENDWHILE;
        }
        if (s2.matches("^\\s*!foreach\\s+.*")) {
            return FOREACH;
        }
        if (s2.matches("^\\s*!endfor\\b.*")) {
            return ENDFOREACH;
        }
        if (s2.matches("^\\s*!(end\\s*function|end\\s*definelong|end\\s*procedure)\\b.*")) {
            return END_FUNCTION;
        }
        if (s2.matches("^\\s*!return\\b.*")) {
            return RETURN;
        }
        if (s2.matches("^\\s*!theme\\b.*")) {
            return THEME;
        }
        if (s2.matches("^\\s*!(include|includeurl|include_many|include_once)\\b.*")) {
            return INCLUDE;
        }
        if (s2.matches("^\\s*!(includedef)\\b.*")) {
            return INCLUDE_DEF;
        }
        if (s2.matches("^\\s*!(import)\\b.*")) {
            return IMPORT;
        }
        if (s2.matches("^\\s*!startsub\\s+.*")) {
            return STARTSUB;
        }
        if (s2.matches("^\\s*!endsub\\b.*")) {
            return ENDSUB;
        }
        if (s2.matches("^\\s*!includesub\\b.*")) {
            return INCLUDESUB;
        }
        if (s2.matches("^\\s*!(log)\\b.*")) {
            return LOG;
        }
        if (s2.matches("^\\s*!(dump_memory)\\b.*")) {
            return DUMP_MEMORY;
        }
        return PLAIN;
    }

    public static boolean isQuote(char ch) {
        return ch == '\"' || ch == '\'';
    }

    public static boolean isLetterOrUnderscoreOrDigit(char ch) {
        return TLineType.isLetterOrUnderscore(ch) || TLineType.isLatinDigit(ch);
    }

    public static boolean isLetterOrUnderscore(char ch) {
        return TLineType.isLetter(ch) || ch == '_';
    }

    public static boolean isLetterOrUnderscoreOrDollar(char ch) {
        return TLineType.isLetterOrUnderscore(ch) || ch == '$';
    }

    public static boolean isLetterOrDigit(char ch) {
        return TLineType.isLetter(ch) || TLineType.isLatinDigit(ch);
    }

    public static boolean isLetter(char ch) {
        return Character.isLetter(ch);
    }

    public static boolean isSpaceChar(char ch) {
        return Character.isSpaceChar(ch);
    }

    public static boolean isLatinDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }
}

